#include "mbed.h"
#include "HMC5883L.h"
#include "DHT.h"
#include "ADXL345.h"
#include "SerialGPS.h"

SerialGPS gps(D1, D0);
DHT sensor(D7, DHT22);
Serial pc(D8, PA_10); // tx, rx 
 // Utility Boussole HMC5883L
#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif
#define PI2         (2*M_PI)
#define RAD_TO_DEG  (180.0/M_PI)
#define DEG_TO_RAD  (M_PI/180.0)
#define  DECLINATION_ANGLE -0.02123
#define SDA      A4
#define SCL      A5
 
int main()
{   
    // varible Boussole HMC5883L  
    double heading;  
    float x, y, z;
    HMC5883L hmc5883l(SDA, SCL);
    // variable DHT11 ///////////////////////////
    float  temp,Humidity;
    int err;
    // configuration GPS //////////////////////////////////////////
    SerialGPS::gps_gga_t *p;
    int    Hour, Min, Sec, Pos, Sat;
    double Latitude, Longitude;

    while(1) 
    { 
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation de la boussole ///////////////////////////
////////////////////////////////////////////////////////////////////////////////
        x = hmc5883l.getMx();
        y = hmc5883l.getMy();
        z = hmc5883l.getMz();     
        pc.printf("x, y, z: %f, %f,%f \r\n",x,y,z);
        heading = atan2(static_cast<double>(y), static_cast<double>(x)); // heading = arctan(Y/X)
        heading += DECLINATION_ANGLE; 
        if(heading < 0.0) // fix sign
            heading += PI2;
        if(heading > PI2) // fix overflow
            heading -= PI2; 
        pc.printf("heading:%f\r\n",heading);
        pc.printf("*********************\r\n");           
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation du capteur de température/////////////////
////////////////////////////////////////////////////////////////////////////////
        err = sensor.readData();
        if (err==0){
            temp=sensor.ReadTemperature(CELCIUS);
            Humidity=sensor.ReadHumidity();
            pc.printf(" temp / hem =%f, %f\r\n",temp,Humidity);  
       }
        pc.printf("*********************\r\n");           
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation gps ////////////:::::::::::::::///////////
////////////////////////////////////////////////////////////////////////////////
         gps.processing();
         Hour= p->hour;
         Min = p->min;
         Sec = p->sec;
         Pos = p->position_fix;
         Sat = p->satellites_used;
         Latitude = p->latitude;
         Longitude= p->longitude;  
         pc.printf("gps= %d, %d \r\n",Latitude,Longitude);
         pc.printf("hour= %i \r\n",Hour);
         pc.printf("min= %i \r\n",Sec);
         pc.printf("position_fix= %i \r\n",Pos);
         pc.printf("*********************\r\n");           
    
        wait(10); 
    }  
}
