#include "mbed.h"
#include "DHT.h"
#include "HMC5883L.h"
#include "ADXL345.h"
#include "SerialGPS.h"
#define SDA      A4
#define SCL      A5

Serial pc(D8, PA_10);
DHT sensor(D7, DHT11);
HMC5883L compass(SDA, SCL); 
ADXL345 accelerometer(D4, D5, D3, D2);
SerialGPS gps(D1, D0);


int main() {
/////////////// Declaration des différentes variables utilisées //////////////// 
float  temp,Humidity;
float  xBoussole, yBoussole, zBoussole;
int    Hour, Min, Sec, Pos, Sat;
double Latitude, Longitude;
/////////////////// configuration de la liaison serie ////////////////////////// 
    pc.baud(9600); //speed(baud)
    pc.format(8,Serial::None,1); //format(bits,SerialBase,stop_bits)
/////////////////// configuration du cap température ///////////////////////////
    int err;
/////////////////// configuration de la Boussole /////////////////////////////// 
    HMC5883L hmc5883l(SDA, SCL);
/////////////////// configuration de l'accélérométre ///////////////////////////
    int readings[3] = {0, 0, 0};
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
    //Measurement mode.
    accelerometer.setPowerControl(0x08);
/////////////////// configuration GPS //////////////////////////////////////////
SerialGPS::gps_gga_t *p;

  while(1) { 
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation du capteur de température/////////////////
////////////////////////////////////////////////////////////////////////////////
    err = sensor.readData();
    //if (err==0){
        temp=sensor.ReadTemperature(CELCIUS);
        Humidity=sensor.ReadHumidity();

   // }else
   //     pc.printf("\r\Error DHT %i \n",err);
       wait(5);    
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation de la boussole ///////////////////////////
////////////////////////////////////////////////////////////////////////////////
        xBoussole = hmc5883l.getMx();
        yBoussole = hmc5883l.getMy();
        zBoussole = hmc5883l.getMz();

         wait(5);    
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation de l'accélérométre ///////////////////////
////////////////////////////////////////////////////////////////////////////////
    accelerometer.getOutput(readings);
  //  pc.printf("accelerometre %i, %i, %i\r\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
  //  pc.printf("AT$SS= %x \r\n",(int)readings[0]);  
  //  pc.printf("AT$SS= %x \r\n",(int)readings[1]);  
   // pc.printf("AT$SS= %x \r\n",(int)readings[2]);  

    
////////////////////////////////////////////////////////////////////////////////
////////////////////////// aquisation gps ////////////:::::::::::::::///////////
////////////////////////////////////////////////////////////////////////////////
      gps.processing();
      Hour= p->hour;
      Min = p->min;
      Sec = p->sec;
      Pos = p->position_fix;
      Sat = p->satellites_used;
      Latitude = p->latitude;
      Longitude= p->longitude;
     //   pc.printf("AT$SS= %f \r\n",temp); 
     //   pc.printf("AT$SS= %f \r\n",Humidity);  
       //  pc.printf("AT$SS= %8x \r\n",*((int *)&xBoussole));  
      //   pc.printf("AT$SS= %8x \r\n",(int)yBoussole);  
     //    pc.printf("AT$SS= %8x \r\n",(int)zBoussole);  
     //   pc.printf("AT$SS= %x \r\n", (int)Latitude);
     // pc.printf("AT$SS=00 12 FF 42 \r\n"); 
     // pc.printf("humidity= %4.2f C\r\n",); 
      // pc.printf("AT$SS= %x \r\n", (int)Longitude);
      //////////////////////////////////////////////
       pc.printf("AT$SS= %x%x \r\n", (unsigned char*)&Longitude,(unsigned char*)&Latitude);

     //  pc.printf("AT$SS= %x \r\n", (int)Longitude);

    wait(0);    
 
  }
}
 