#include "mbed.h"

/**************************************************************************
***************************************************************************

Shows p20 voltage on a dual digit 7 segment display common cathode
MAN6740 with a array of resistances MDP1403-221G (7 * 220 ohms) modified
by Fabio Augusto Bitencourt and based on a counter made 
by Amos 12/10/2010 (that's October 12th!) 


***************************************************************************
***************************************************************************/

#include "mbed.h"

AnalogIn input(p20);//the range of the analog input goes, from 0V to 3.3V.
//the actual value is represented as a float from 0 to 1.
DigitalOut myLeftPins[] = {p7, p8, p9, p10, p11, p12, p13};
DigitalOut myRightPins[] = {p21, p22, p23, p24, p25, p26, p27};

/*
Individual numerals
int zero[] = {0, 0, 0, 1, 0, 0, 0};
int one[] = {0, 1, 1, 1, 1, 1, 0};
int two[] = {1, 0, 0, 0, 0, 1, 0};
int three[] = {0, 1, 0, 0, 0, 1, 0};
int four[] = {0, 1, 1, 0, 1, 0, 0};
int five[] = {0, 1, 0, 0, 0, 0, 1};
int six[] = {0, 0, 0, 0, 0, 0, 1};
int seven[] = {0, 1, 1, 1, 0, 1, 0};
int eight[] = {0, 0, 0, 0, 0, 0, 0};
int nine[] = {0, 1, 0, 0, 0, 0, 0};
             (c, e, d, g, a, f, b)
*/ 
//This is an array of arrays where the first index into the array
//locates the pin combination which displays that digit
//eg numb[1] returns the array containg the segments to display 1.
int numb[10][7] = {{1, 1, 1, 0, 1, 1, 1},
                {1, 0, 0, 0, 0, 0, 1}, 
                {0, 1, 1, 1, 1, 0, 1}, 
                {1, 0, 1, 1, 1, 0, 1}, 
                {1, 0, 0, 1, 0, 1, 1}, 
                {1, 0, 1, 1, 1, 1, 0}, 
                {1, 1, 1, 1, 1, 1, 0}, 
                {1, 0, 0, 0, 1, 0, 1}, 
                {1, 1, 1, 1, 1, 1, 1}, 
                {1, 0, 1, 1, 1, 1, 1}};

int main()
{
    float ain;//ain must be a float, for matching the input read type.
    while(1)
    {
        for(int i = 0; i < 7; i++)
        {
            //clear all pins
            myLeftPins[i] = 1;
            myRightPins[i] = 1;
        }        
        //Countup loop
        ain=input.read();
        int x = ain*10*3.31;//adjust voltage to show the value at x
        
            //set the main counter
            for(int i = 0; i < 7; i++)
            {
                //Left digit displays the value of x/10 ie the tens column
                myLeftPins[i] = numb[x/10][i]; 
                //Right digit displays the value of x%10 ie the units column
                myRightPins[i] = numb[x%10][i];         
            }
           
           
        wait(1);
    }
}


