#include "mbed.h"
#include "robot.h" // Inicializa o robô. Este include deverá ser usado em todos os main.cpp!
//#include "nRF24L01P.h"
#include <RF24.h>

#define TRANSFER_SIZE 1

//nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTC13, PTC12, PTA13);
RF24 radio(PTD2, PTD3, PTD1,  PTC12 ,PTC13);


void config_init_nrf2()
{
      int resultado;
      resultado = radio.begin();
      
      pc.printf( "Begin=%d\r\n",  resultado );
  radio.setDataRate(RF24_1MBPS);
  radio.setCRCLength(RF24_CRC_8);
  radio.setPayloadSize(1);
  radio.setChannel(101);
  radio.setAutoAck(true);
  radio.printDetails();

  radio.openWritingPipe(0x314e6f6465);
  radio.openReadingPipe(1,0x324e6f6465 );

  radio.startListening();
}

int main()
{
    char txData, rxData;


    initRobot();
    pc.baud(9600);
    config_init_nrf2(); // Should be after pc.baud()
    
    pc.printf( "Robot A\r\n" );
    

    // Desliga os LEDs.
    q_led_red_fro = 1;  //Led Red Front
    q_led_gre_fro = 1;  //Led Green Front
    q_led_blu_fro = 1;  //Led Blue Front
    q_led_red_rea = 1;  //Led Red Rear
    q_led_gre_rea = 1;  //Led Green Rear
    q_led_blu_rea = 1;  //Led Blue Rear

    while (1) {

        // If we've received anything over the host serial link...
        if ( pc.readable() ) {

            // ...add it to the transmit buffer
            txData = pc.getc();
        
                // Send the transmitbuffer via the nRF24L01+
                //pc.printf( "Vou enviar: %c\r\n",txData);
                 radio.stopListening();
                radio.write( &txData, sizeof(txData) );
                radio.startListening();


            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
            q_led_red_fro = !q_led_red_fro;
        }

        // If we've received anything in the nRF24L01+...
        if (radio.available() ) {

            // ...read the data into the receive buffer
            //my_nrf24l01p.read( NRF24L01P_PIPE_P0, &rxData, sizeof( rxData ) );
            radio.read( &rxData, sizeof(rxData) );

 

                pc.putc( rxData );


            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            q_led_red_rea = !q_led_red_rea;
        }
    }
}