#include "Radio.h"
#include "mbed.h"
#include "Rangefinder.h"

RF24 radio(PTD2, PTD3, PTD1,  PTC12 ,PTC13);
const char max_len = 30;

MBED_PACKED(struct) BasicFrame { // MBED_PACKED is required to avoid unpredictable data sizes due to Padding.
    char start_of_frame_1;
    char start_of_frame_2;
    char identifier;
} BasicFrame1;

MBED_PACKED(struct) MatrixFrame { // MBED_PACKED is required to avoid unpredictable data sizes due to Padding.
    char start_of_frame_1;
    char start_of_frame_2;
    char identifier;
    char dim1;
    char dim2;
} MatrixFrame1;

/**
 * Initializes nrf24l01 module, return value 1 if module is working correcty and 0 if it's not.
 *
 ** @param channel - Which RF channel to comunicate on, 0-125
 *
 * \warning Channel on Robot and Board has to be the same.
 */
bool init_nRF(int channel)
{
    bool result;

    result = radio.begin();
    //pc.printf( "Initialation nrf24l01=%d\r\n",  result ); // 1-working,0-not working
    radio.setDataRate(RF24_250KBPS);
    radio.setCRCLength(RF24_CRC_16);
    radio.enableDynamicPayloads();
    radio.setChannel(channel);
    radio.setAutoAck(true);

    radio.openWritingPipe(0x314e6f6465);
    radio.openReadingPipe(1,0x324e6f6465);

    radio.startListening();

    return result;
}

void radio_send_string(char *str)
{
    char *ptr;

    ptr = str;

    while(strlen(ptr) > max_len) {
        radio.stopListening();
        radio.write(ptr, max_len);
        radio.startListening();
        ptr += max_len;
    }

    radio.stopListening();
    radio.write(ptr, strlen(ptr));
    radio.startListening();
}

void send_float_matrix(float *matrix, unsigned num_lines, unsigned num_columns)
{
    int num_bytes_to_send;
    uint8_t *ptr;

    // Send frame structure.
    MatrixFrame1.start_of_frame_1 = 0x06;
    MatrixFrame1.start_of_frame_2 = 0x85;
    MatrixFrame1.identifier = 'F';
    MatrixFrame1.dim1 = num_lines;
    MatrixFrame1.dim2 = num_columns;

    radio.stopListening();
    radio.write(&MatrixFrame1, sizeof(MatrixFrame1));

    // Send matrix.
    ptr = (uint8_t*)matrix;
    num_bytes_to_send = num_lines * num_columns * sizeof(float);

    while(num_bytes_to_send > max_len) {
        radio.write(ptr, max_len); // It would be helpful a blocking function. write() should block, but it appears been modified.
        ptr += max_len;
        num_bytes_to_send -= max_len;
    }

    radio.write(ptr, num_bytes_to_send);
    radio.startListening();
}

void send_rangefinder()
{
    BasicFrame1.start_of_frame_1 = 0x06;
    BasicFrame1.start_of_frame_2 = 0x85;
    BasicFrame1.identifier = 'R';

    radio.stopListening();
    radio.write(&BasicFrame1, sizeof(BasicFrame1));
    radio.write(rgfMeasurements, sizeof(rgfMeasurements));
    radio.startListening();
}

void test_send_matrix()
{
    const int lines_num = 15, col_num = 15;
    float testmatrix[lines_num][col_num];
    int i, j;
    float previous = 0.1;

    for(i=0; i<lines_num; i++) {
        for(j=0; j<col_num; j++) {
            testmatrix[i][j] = previous;
            previous += 0.1;
        }
    }

    send_float_matrix(&testmatrix[0][0], lines_num, col_num);
}