#include "mbed.h"
#include "Robot.h"
#include "Communication.h"

Serial pc(SERIAL_TX, SERIAL_RX);

int main() {
    float odomX, odomY, odomTheta;
    pc.baud(115200);
    init_communication(&pc);
    
    while(1) {
        getCountsAndReset(); // Call getCountsAndReset() to read the values of encoders
                             // and reset them. The values become available on variables
                             // "countsLeft" and "countsRight".
        
        // setSpeeds(20, 50); // Uncomment to set a speed of 20 for the
                              // left motor and 50 for the right motor.
        
        pc.printf("ASCII message - Left=%d   Right=%d\n", countsLeft, countsRight);
        send_odometry(1, 2, countsLeft, countsRight, odomX, odomY, odomTheta);
        wait(0.5); // Delay of 0.5 seconds.
    }
}