#include "ComSPI.h"
SPI SPI_Master(p11, p12, p13);          //mosi, miso, sck
DigitalOut cs(p14);                     //Selection Slave
SPISlave SPI_Slave(p5, p6, p7, p8);     //mosi, miso, sck, ssel
volatile int attente;


void v_InitSPI(){
    SPI_Master.format(8,0);
    SPI_Master.frequency(1000000);    
    SPI_Slave.format(8,0);
    SPI_Slave.frequency(1000000); 
}


void v_TestComSPI(){
    attente=0;
    v_InitSPI();
    Thread tSlave(v_threadSPISlave);
    Thread tMaster(v_threadSPIMaster);
    while(attente==0);
}

void v_threadSPIMaster(void const* argument){    
    int answer, msgsend=1;
    cs=0;
    answer = SPI_Master.write(msgsend);   
    cs=1;  
    wait_ms(100);
    cs=0;
    answer = SPI_Master.write(0x00); 
    cs=1;
    
    printf("Master -> Valeur envoye :%d  Valeur recu : %d \r\n", msgsend, answer);
    if(answer == (msgsend+5)){          //Normaly slave returns msgsend + 5
        cs=0;
        answer=SPI_Master.write(TERMINATE);   //send a Terminate value
        cs=1;  
        if(answer==0) printf("Communication SPI OK \r\n)");    //Normaly Slave returns 0 : end of transmission
        else printf("Probleme de communication SPI1 \r\n)");
    }  
    else{
        printf("Probleme de communication SPI2 \r\n");
        }
        attente++;
}

void v_threadSPISlave(void const* argument){
     int rec, rec2;
     bool end=false;
     while(!end){
         if(SPI_Slave.receive()) {
                rec = SPI_Slave.read(); 
                rec2=rec+5;                   // Read byte from master
                printf("Slave -> Valeur recue :%d\r\n", rec);                  
                if(rec!=0){                                  // discard the dummy buffer write
                    if(rec == TERMINATE) {                   //if terminate signal : stop kill thread
                        printf("Signal Termine \r\n");
                        end = true;
                        SPI_Slave.reply(0);
                     }
                     
                     else{ 
                        SPI_Slave.reply(rec2);                   // Make this the next reply (add 5);
                        printf("Slave -> Valeur renvoyee : %d \r\n",rec2);
                        }
                }      
          }
      }
}

