#include "mbed.h"
#include "MODSERIAL.h"
//#include "biquadFilter.h"
#include "math.h"
#include "HIDScope.h"
#include "QEI.h"

// Occupied pins A1,D2,D4,D5,D12,D13
DigitalOut motor1_dir(D4);
PwmOut motor1_mag(D5);
QEI motor1_pos(D13 ,D12 ,NC, 64 ,QEI::X4_ENCODING); // D12 on A D13 on B

DigitalIn button_1(D2);
DigitalIn button_2(D3);
AnalogIn potMeter_1(A1);

MODSERIAL pc(USBTX, USBRX);

float getReferenceVelocity();
float feedforwardControl(float);
void setMotor_1(float);
bool getDirection(bool);
float pulsesToDegrees(int);
void test_hid_ticker();
void initpositionGo();

const float maxVelocity= 8.4; // should be 8.4 for 80 RPM 
const float motorGain= 8.4; // unit: (rad/s)
const int CW = 1;
const int CCW = 0;

bool direction = 1;

int main()
{
    while (button_2) {
        
        float ReferenceVelocity = getReferenceVelocity(); // returns direction + speed in rad/s
        float motorValue = feedforwardControl(ReferenceVelocity); // returns value between -1 and 1
        setMotor_1(motorValue); // adjust motor
        //float motor1_deg = pulsesToDegrees(motor1_pos.getPulses()) % 360;
        //pc.printf("motor1_deg: %f \n", motor1_deg);
        int pulses = motor1_pos.getPulses();
        pc.printf("Pulses: %d\n\r", pulses);
        //float revolutions = float(pulses/8400.00); // 8384 or 8400, output shaft revolutions
        //pc.printf("Revolutions: %f\n", revolutions); 
        wait(0.002);
    }
motor1_mag.write(0);
}

float getReferenceVelocity() // Returns reference velocity in rad/s. 
{
    float referenceVelocity;  // in rad/s
    float potmeter1 = potMeter_1.read(); // read out potmeter
    pc.printf("%f\n", potmeter1);
    if (getDirection(direction) == CW)   { // Clockwise rotatio
        referenceVelocity = potmeter1 * maxVelocity; 
    } 
    else { // Counterclockwise rotation      
        referenceVelocity = -1*potmeter1 * maxVelocity;  
    }
    pc.printf("referenceVelocity: %f\n", referenceVelocity);
    return referenceVelocity; // duty cycle compensated
}

float feedforwardControl(float referenceVelocity)
{
    float motorValue = referenceVelocity / motorGain;
    pc.baud(115200);
    pc.printf("motorValue: %f\n\r", motorValue);
    return motorValue; // between -1 and 1
}

void setMotor_1(float motorValue) //  this sets the PWM and direction
{

    if (motorValue >=0){ 
        motor1_dir.write(CW); 
    }
    else {
        motor1_dir.write(CCW);
    }
    int motor1_Dir = motor1_dir;
    pc.printf("motor1_dir: %d\n\r", motor1_Dir);
    
    if (fabs(motorValue)>1) {
        motor1_mag.write(1); // safety, magnitude max 1
    }   
    else {
        motor1_mag.write(fabs(motorValue));   //PWM Speed Control
    }
    float motor1_Mag = motor1_mag;
    pc.printf("motor1_mag: %f\n\r", motor1_Mag);
}

bool getDirection(bool Direction){
    if (!button_1){ // pressed

   return 1; 
            
   }
   else { return 0;}
}

// not pressed is positive for long side SO going RIGHT, so DIR is 1
// presssed is negative for long side so going left, so DIR is 0
// not pressed is positive for short side so going up, so DIR is 1
// pressed is negative for short side so going down, so DIR is 0

/*float pulsesToLinpos(int pulses) {
    float Linpos = ((pulses)/(X*N))*(1/PPCM );
    return Linpos; // in Centimeters
}
*/

/*float revToDegrees(float revolutions){
    double degrees = revolutions*360;
}
*/

void initpositionGo(){
bool initposition = false;
    while (initposition){
        float pulseCount = motor1_pos.getPulses();
        if ( pulseCount < 0) {
            motor1_dir.write(CW); 
        }
        else if (pulseCount > 0){
            motor1_dir.write(CCW); 
        }
        else {
        initposition = true;
        }
    }
}
