#include "SigInterpreter.h"

BiQuadChain bqc;
BiQuad bq1(a1_1,a2_1,b0_1,b1_1,b2_1);
BiQuad bq2(a1_2,a2_2,b0_2,b1_2,b2_2);
BiQuad bq3(a1_3,a2_3,b0_3,b1_3,b2_3);
BiQuad bq4(a1_4,a2_4,b0_4,b1_4,b2_4);
BiQuad bq5(a1_5,a2_5,b0_5,b1_5,b2_5);

AnalogIn emg1(A0);
AnalogIn emg2(A1);
AnalogIn emg3(A2);
AnalogIn emg4(A3);
   
SigInterpreter::SigInterpreter() 
{

}

double SigInterpreter::readValue(int sig) {
    // returns the amplitude of EMG signal
    if(sig > 4 || sig < 1) 
    { 
        // nope
        return 0.0;     // check later of dit idd goeie shit is
    } 
    if (sig == 1) 
    {
        float input = emg1.read();
        return (filter(input));
    }
    if (sig == 2) 
    {
        float input = emg2.read();
        return (filter(input));
    } 
    if (sig == 3) 
    {
        float input = emg3.read();
        return (filter(input));
    }
    if (sig == 4) 
    {
        float input = emg4.read();
        return (filter(input));
    }
    else 
    {     
        return 0.0;
    }
}

double SigInterpreter::filter(float input){
  
    float highpass1 = bq1.step(input);

    float highpass2 = bq2.step(highpass1);
    /*
    float lowpass1 = bq3.step(highpass2);
   
    float lowpass2 = bq4.step(lowpass1);
    
    float lowpass3 = bq5.step(lowpass2);
    */
    
    return fabs(input);
}

