#include "SigInterpreter.h"

/*
const double b0_1 = 0.86746769957;
const double b1_1 = -1.73493539914;
const double b2_1 = 0.86746769957;
const double a1_1 = -1.72399696946;
const double a2_1 = 0.74581276783;

const double b0_2 = 0.93721236427;
const double b1_2 = -1.87442472855;
const double b2_2 = 0.93721236427;
const double a1_2 = -1.82350353127;
const double a2_2 = 0.8862430266;

*/
BiQuad bq1_1(-1.72399696946,0.74581276783,0.86746769957,-1.73493539914,0.86746769957);
BiQuad bq1_2(-1.82350353127,0.8862430266,0.93721236427,-1.87442472855,0.93721236427);
BiQuad bq1_3( 3.00955e-10, 3.00615e-10, 0.00000e+00, -9.75178e-01, 0.00000e+00 );
BiQuad bq1_4( 1.00000e+00, 2.00183e+00, 1.00183e+00, -1.95953e+00, 9.60149e-01 );
BiQuad bq1_5( 1.00000e+00, 1.99930e+00, 9.99302e-01, -1.98396e+00, 9.84588e-01 );

BiQuad bq2_1(-1.72399696946,0.74581276783,0.86746769957,-1.73493539914,0.86746769957);
BiQuad bq2_2(-1.82350353127,0.8862430266,0.93721236427,-1.87442472855,0.93721236427);
BiQuad bq2_3( 3.00955e-10, 3.00615e-10, 0.00000e+00, -9.75178e-01, 0.00000e+00 );
BiQuad bq2_4( 1.00000e+00, 2.00183e+00, 1.00183e+00, -1.95953e+00, 9.60149e-01 );
BiQuad bq2_5( 1.00000e+00, 1.99930e+00, 9.99302e-01, -1.98396e+00, 9.84588e-01 );

BiQuad bq3_1(-1.72399696946,0.74581276783,0.86746769957,-1.73493539914,0.86746769957);
BiQuad bq3_2(-1.82350353127,0.8862430266,0.93721236427,-1.87442472855,0.93721236427);
BiQuad bq3_3( 3.00955e-10, 3.00615e-10, 0.00000e+00, -9.75178e-01, 0.00000e+00 );
BiQuad bq3_4( 1.00000e+00, 2.00183e+00, 1.00183e+00, -1.95953e+00, 9.60149e-01 );
BiQuad bq3_5( 1.00000e+00, 1.99930e+00, 9.99302e-01, -1.98396e+00, 9.84588e-01 );

BiQuad bq4_1(-1.72399696946,0.74581276783,0.86746769957,-1.73493539914,0.86746769957);
BiQuad bq4_2(-1.82350353127,0.8862430266,0.93721236427,-1.87442472855,0.93721236427);
BiQuad bq4_3( 3.00955e-10, 3.00615e-10, 0.00000e+00, -9.75178e-01, 0.00000e+00 );
BiQuad bq4_4( 1.00000e+00, 2.00183e+00, 1.00183e+00, -1.95953e+00, 9.60149e-01 );
BiQuad bq4_5( 1.00000e+00, 1.99930e+00, 9.99302e-01, -1.98396e+00, 9.84588e-01 );



AnalogIn emg1(A0);
AnalogIn emg2(A1);
AnalogIn emg3(A2);
AnalogIn emg4(A3);
   
SigInterpreter::SigInterpreter() 
{

}

float SigInterpreter::readValue(int sig) {
    // returns the amplitude of EMG signal
    if(sig > 4 || sig < 1) 
    { 
        // nope
        return 0.0;
    } 
    if (sig == 1) 
    {
        return (filter1(emg1.read()));
    }
    if (sig == 2) 
    {
        return (filter2(emg2.read()));
    } 
    if (sig == 3) 
    {
        return (filter3(emg3.read()));
    }
    if (sig == 4) 
    {
        return (filter4(emg4.read()));
    }
    else 
    {     
        return 0.0;
    }
}

float SigInterpreter::filter1(float input){ 
  
    highpass1 = bq1_1.step(input);
    highpass2  = bq1_2.step(highpass1);
    rect = fabs(highpass2);
    lowpass1 = bq1_3.step(rect);
    lowpass2 = bq1_4.step(lowpass1);
    lowpass3 = bq1_5.step(lowpass2);
    
    return lowpass3;
}

float SigInterpreter::filter2(float input){ 
  
    highpass1 = bq2_1.step(input);
    highpass2  = bq2_2.step(highpass1);
    rect = fabs(highpass2);
    lowpass1 = bq2_3.step(rect);
    lowpass2 = bq2_4.step(lowpass1);
    lowpass3 = bq2_5.step(lowpass2);
    
    return lowpass3;
}

float SigInterpreter::filter3(float input){ 
  
    highpass1 = bq3_1.step(input);
    highpass2  = bq3_2.step(highpass1);
    rect = fabs(highpass2);
    lowpass1 = bq3_3.step(rect);
    lowpass2 = bq3_4.step(lowpass1);
    lowpass3 = bq3_5.step(lowpass2);
    
    return lowpass3;
}

float SigInterpreter::filter4(float input){ 
  
    highpass1 = bq4_1.step(input);
    highpass2  = bq4_2.step(highpass1);
    rect = fabs(highpass2);
    lowpass1 = bq4_3.step(rect);
    lowpass2 = bq4_4.step(lowpass1);
    lowpass3 = bq4_5.step(lowpass2);
    
    return lowpass3;
}


