#include "mbed.h"

/*****************************************************************************
generar un programa que controle por el puerto serial el grado de 4 servo motores.
por medio de la comunicacion serial el comando es 

|            |            |             |
|   INITCMD  |   N_motor  |   N_grados  |
|     0xff   | 0x01- 0x04 | 0x00 - 0xb4 |

para enviar los comandos usar el programa Coolterm http://freeware.the-meiers.org/

# para el servo motor se debe modificar el ciclo util del PWM SEGUN:
#     ________              ________
# ___|        |____________|        |___________
#    <-width->
#    <-------period 20ms--->
# period = 20 ms
# width  = 1000us y 2000us
#  1000us para 0 grados
#  2000us para 180 grados
#

*****************************************************************************/


Serial command(USBTX, USBRX);
PwmOut myservo1(PB_4);
/*INGRESE LA CONFIGURACION DE LOS MOTORES*/

#define INITCMD 0xFF
#define DEGREES_MAX 180

// definición de las variables globales 

uint8_t N_motor;    // variable almacena el número de motor en leer_datos()
uint8_t N_grados;    // varable almacena los grados que se mueve el motor en leer_datos()


// definición de las funciones
void setup_uart();
void setup_servo();

void mover_servo(uint8_t motor, uint8_t gradss);
uint32_t degrees2usec(uint8_t grados);

void leer_datos();

    
    
int main() {

    setup_uart();
    setup_servo();
    //command.printf("inicio de programa");
    while(1){    
        leer_datos();
        mover_servo(N_motor, N_grados);
    }    
}



void setup_uart(){
    command.baud(115200);
}

void setup_servo(){
    myservo1.period_ms(20);
    myservo1.pulsewidth_us(2000);
}

void leer_datos(){
    while(command.getc()!= INITCMD);
    N_motor=command.getc();
    N_grados=command.getc();
    
}


uint32_t degrees2usec(uint8_t grados){
// Retorna el valor en microsegundos, donde
//      y − y1 = m(x − x1 )
//      y=  b + mx

    if(grados <= DEGREES_MAX)
        return int(750+grados*1900/180);// u6
    return 750;
    
}

void mover_servo(uint8_t motor, uint8_t grados){

        uint32_t dpulse=0;
        
/* complementar el código necesario
   tip: deben pasar  grados a microsegundo */


    dpulse=degrees2usec(grados);
    if (motor==1)
         myservo1.pulsewidth_us(dpulse);

}


