#include "mbed.h"
#include "scolor_TCS3200.h"

/* *****************************************************************************
Programa que solicita telemetria al sistema embebido, por medio del comando  0xFe
para preguntar por el color  que detecta el sensor TCS3200

el sistema embebido recibe  el inicio de trama FE  y el número de comado: 01
   
|   INITELE  |  CMD       |   
|     0xfe   | 0x01       | 


para enviar los comandos usar el programa Coolterm http://freeware.the-meiers.org/


@fabeltranm 2019
fbeltranm@ecci.edu.co

********************************************************************************
   datasheet https://www.mouser.com/catalog/specsheets/TCS3200-E11.pdf


    S0      Frequency scaling 
    S1      Frequency scaling 
    S2      Photo diode selection 
    S3      Photo diode selection 
    OutFreq Frequency

       -----------------------------------
      |   ____________     ____________   |
----> |  |            |   |            |  |                ___     ___ 
Light |  | Photodiode |   |   Current  |--|---OUTPUT_FREQ |   |___|   |___
----> |  |   Array    |---|     to     |  |
      |  |            |   |  Frequency |  |
      |  |____________|   |____________|  |
      |       ^  ^             ^  ^       |
       -------|--|-------------|--|-------
              |  |             |  |
             S2 S3            S0  S1
             
SO | S1 | OUTPUT FREQUENCY SCALING |        | S2 | S3 |   PHOTODIODE TYPE   |
 0 | 0  |        power down        |        |  0 | 0  |         Red         |
 0 | 1  |           2%             |        |  0 | 1  |         Blue        |
 1 | 0  |           20%            |        |  1 | 0  |  Clear (no filter)  |
 1 | 1  |           100%           |        |  1 | 1  |         Green       | 
             
******************************************************************************/

#define INITELE 0xFE
#define CMD  0x01



Serial command(USBTX, USBRX);
//                     S0,    S1,   S2,   S3,    OUT
scolor_TCS3200 scolor(PA_8, PB_10, PB_9, PB_5, PB_8);

// definición de las funciones
void setup_uart();
void leer_datos();
void leer_color();

uint8_t cmd;

int main() {

    setup_uart();
    while(1){    
        leer_datos();
        if (cmd==CMD){}
            leer_color();
    }    
}



void setup_uart(){
    command.baud(115200);
}


void leer_datos(){
    while(command.getc()!= INITELE);
    cmd=command.getc();

    
}


void leer_color(){
    
 
    long     red    ;
    long     green ;
    long     blue  ;
    long     clear ;


       red = scolor.ReadRed();
       green = scolor.ReadGreen();
       blue = scolor.ReadBlue();
       clear = scolor.ReadClear();
     
        printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d    \n ", red, green, blue, clear);
    
    

    
}    