
#include "mbed.h"
#include "figuras.h"

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
Serial command(USBTX, USBRX);

#define DEBUG 1
#define  VELOCITY 500 // ms

void debug_m(char *s , ... );

uint8_t matrix_act[8]={0,0,0,0,0,0,0,0};
uint8_t matrix_tmp[11]={0,0,0,0,0,0,0,0,0,0};
uint8_t matrix_fig[3]={0,0,0};
  
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};


void printMatrix(uint8_t*  vC)

{
    uint8_t i =0;
    for (i=1;i<9;i++){
        sendSPI(i,*(vC+i-1));
    }
        
    };



int init_display(){
    sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x09,0);
    sendSPI(0x0A,0x0f);
    printMatrix(matrix_act);
    int i;
    for (i=0;i<2;i++){
        sendSPI(0x0F,1);
        wait (0.5);
        sendSPI(0x0f,0);
        wait (0.5);
    }
 }
 
void actualizar_matrix(){ 
    for (int i=fig_act.posx; i<fig_act.posx+3;i++)
        matrix_act[i]= fig_act.fig[i] ;
 
 } 


void copy_fig(uint8_t*  m2, uint8_t ncol){
   for (int i=0; i<3;i++){
        fig_act.fig[i]= *(m2+i);
        debug_m("%b\n",*(m2+i));
    }
    fig_act.posx=ncol;
    
} 



void new_read(){
    uint8_t tf=command.getc();
    char nc=command.getc();
    debug_m("se recibe la figura %d, en la columna %d",tf);
    switch (tf) {
    case  L_TYPE: 
        copy_fig(FIG_L,nc);
        break ;     
    case  S_TYPE: 
        copy_fig(FIG_S,nc);
        break ;     
    case  I_TYPE: 
        copy_fig(FIG_I,nc);
        break ;     
    default: 
        copy_fig(FIG_NULL,nc);
        
    }
    
    
}

void desplazar_fila(){
     for (int i=0; i<3;i++)
        fig_act.fig[i]= fig_act.fig[i]>>1;
    
}
int main() {
    init_display();
    while(1){
       new_read();
       for(int i=0;i<8;i++){
            desplazar_fila();
            actualizar_matrix();
            printMatrix(matrix_act);
            wait_ms(VELOCITY);
       }   
    }
}


void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}