#include "MapleMini.h"
#include "mbed.h"
#include "nintendo.h"
 
int *NintendoNes()    
{
    USB2.output(); // CLOCK
    USB3.output(); // LATCH
    USB4.input();  // DATA
    USB4.mode(PullUp);

    USB3 = 0;
    USB2 = 0;

    // Flag des boutton
    const int UP     = 1;
    const int DOWN   = 2;
    const int LEFT   = 4;
    const int RIGHT  = 8;
    const int A      = 64;
    const int B      = 128;
    const int SELECT = 1024;
    const int START  = 2048;

    int buttonMap[] = {
        A,
        B,
        SELECT,
        START,
        UP,
        DOWN,
        LEFT,
        RIGHT
    };

    int buttons = 0;

    // Envoi impulsion LATCH
    USB3 = 1;
    wait_us(12);
    USB3 = 0;
    wait_us(6);

    // Lecture des boutons
    for (int i = 0; i < 8; i++) {
        if(!USB4) { // Lecture du boutton
            buttons |= buttonMap[i];
        }
        // Envoi impulsion CLOCK
        USB2 = 1;
        wait_us(6);
        USB2 = 0;
        wait_us(6);
    }
    int array[] = {0, 0, 0, 0, buttons, 0};
    return array;
    //joystick.update(0, 0, 0, 0, buttons, 0); // Envoi des position des noutton au pc
}

int *NintendoSnes()    
{
    USB2.output(); // CLOCK
    USB3.output(); // LATCH
    USB4.input();  // DATA
    USB4.mode(PullUp);

    USB3 = 0;
    USB2 = 0;
    
    

    // Flag des boutton
    const int UP     = 1;
    const int DOWN   = 2;
    const int LEFT   = 4;
    const int RIGHT  = 8;
    const int L      = 16;
    const int R      = 32;
    const int A      = 64;
    const int B      = 128;
    const int X      = 256;
    const int Y      = 512;
    const int SELECT = 1024;
    const int START  = 2048;
    
    int buttonMap[] = {
        B,
        Y,
        SELECT,
        START,
        UP,
        DOWN,
        LEFT,
        RIGHT,
        A,
        X,
        L,
        R
    };

    int buttons = 0;
    int analog_l = -128;
    int analog_r = -128;

    // Envoi impulsion LATCH
    USB3 = 1;
    wait_us(12);
    USB3 = 0;
    wait_us(6);

    // Lecture des boutons
    for (int i = 0; i < 12; i++) {
        if(!USB4) { // Lecture du boutton
            buttons |= buttonMap[i];
        }
        // Envoi impulsion CLOCK
        USB2 = 1;
        wait_us(6);
        USB2 = 0;
        wait_us(6);
    }
    int array[] = {analog_r, analog_l, 0, 0, buttons, 0};
    return array;
    //joystick.update(0, 0, 0, 0, buttons, 0); // Envoi des position des noutton au pc
}