#include "MapleMini.h"
#include "mbed.h"
#include "USBJoystick.h"

#include "nintendo.h"
#include "sega.h"

    DigitalInOut USB2(PB_12);
    DigitalInOut USB3(PB_13);
    DigitalInOut USB4(PB_14);
    DigitalInOut USB5(PB_15);
    DigitalInOut USB6(PA_8);
    DigitalInOut USB7(PA_9);
    DigitalInOut USB8(PA_10);
    DigitalInOut USB9(PA_15);
    
int main() {
    
    DigitalOut  myled(LED1);
    
    confSysClock(); 
    USBJoystick joystick;
    Serial pc(USBTX, USBRX);

    int controller = 0;
    
    while(1) {
        
        int idLow = 0;
        int idHigh = 0;

        USB5.input();
        USB6.input();
        USB7.input();
        USB8.output();
        USB9.input();
        
        USB5.mode(PullUp);
        USB6.mode(PullUp);
        USB7.mode(PullUp);
        USB9.mode(PullUp);
        
        if(!USB9) {
            USB8 = 0;
            wait_us(1);
            if(!USB7) {
                idLow = idLow + 1;
            }
            if(!USB6) {
                idLow = idLow + 2;
            }
            if(!USB5) {
                idLow = idLow + 4;
            }

            USB8 = 1;
            wait_us(1);
            if(USB7) {
                idHigh = idHigh + 1;
            }
            if(USB6) {
                idHigh = idHigh + 2;
            }
            if(USB5) {
                idHigh = idHigh + 4;
            }

            if(idHigh == 7) {
                controller = idLow;
                //pc.printf("idLow : %i idHigh : %i\r\n",idLow,idHigh);
            } else {
//                pc.printf("Error idLow : %i idHigh : %i\r\n",idLow,idHigh);
                //wait_ms(100);
            }
                switch(controller) {
                    case 0:
                        int *sega = SegaMasterGenesisSaturn();
                        joystick.update(sega[0],sega[1],sega[2],sega[3],sega[4],sega[5]); // Envoi des position des noutton au pc
 //                       pc.printf("Sega ou Saturn \r\n");
                        //pc.printf("X : %i - Y : %i \r\n", sega[2], sega[3]);
                        break;
                    case 3:
 //                       pc.printf("PS1\r\n");
                        break;
                    case 4:
                        int *nes = NintendoNes();
                        joystick.update(nes[0],nes[1],nes[2],nes[3],nes[4],nes[5]); // Envoi des position des noutton au pc
 //                       pc.printf("NES\r\n");
                        break;
                    case 5:
                        int *snes = NintendoSnes();
                        joystick.update(snes[0],snes[1],snes[2],snes[3],snes[4],snes[5]); // Envoi des position des noutton au pc
//                        pc.printf("SNES\r\n");
                        break;
                    case 6:
 //                       pc.printf("Dreamcast\r\n");
                        break;
                    case 7:
//                       pc.printf("N64\r\n");
                        break;
                }
        } else {
            pc.printf("Pas d'adaptateur\r\n");
            wait_ms(100);
        }
        myled = !myled;
    }
}