#include "MapleMini.h"
#include "mbed.h"
#include "nintendo.h"
 
int *SegaMasterGenesisSaturn()    
{                  // AUTRE   SATURN      SATURN 3D
    USB2.input();  // UP      DATA 1  0v  DATA 1  0v
    USB3.input();  // DOWN    DATA 0  0v  DATA 0  5v
    USB4.input();  // LEFT    SELECT0     SELECT
    USB5.input();  // RIGHT   DATA 3  5v  DATA 3  0v
    USB6.input();  // B       DATA 2  5v  DATA 2  0v
    USB7.output(); // SELECT  SELECT1     REQ
    USB8.input();  // C       --          ACK
    
    USB2.mode(PullUp);
    USB3.mode(PullUp);
    USB4.mode(PullUp);
    USB5.mode(PullUp);
    USB6.mode(PullUp);
    USB8.mode(PullUp);
    
    // Flag des boutton
    const int UP    = 1;
    const int DOWN  = 2;
    const int LEFT  = 4;
    const int RIGHT = 8;
    const int X     = 16;
    const int Z     = 32;
    const int C     = 64;
    const int B     = 128;
    const int Y     = 256;  
    const int A     = 512;
    const int START = 2048;
    const int GND   = 0;
    const int MODE  = 8192;

    // Tableau avec les pin et leur valeur
    // pin, Master System, 3 btn select 0V, 3 btn select 5V, 6 btn........
/*    int buttonMap[6][11] = {
       //SMS    SMD    -      SMD6   -      -      -      -    -     -  -
       //0V     0V     5V     0      1      2      3      4    5     6  7
        {UP,    UP,    UP,    UP,    UP,    UP,    UP,    GND, Z,    0, 0}, //USB2
        {DOWN,  DOWN,  DOWN,  DOWN,  DOWN,  DOWN,  DOWN,  GND, Y,    0, 0}, //USB3
        {LEFT,  GND,   LEFT,  GND,   LEFT,  GND,   LEFT,  0,   X,    0, 0}, //USB4
        {RIGHT, GND,   RIGHT, GND,   RIGHT, GND,   RIGHT, 0,   MODE, 0, 0}, //USB5
        {B,     A,     B,     A,     B,     A,     B,     0,   0,    0, 0}, //USB6
        {C,     START, C,     START, C,     START, C,     0,   0,    0, 0}  //USB8
    };
    
    USB2 DATA 1 
    USB3 DATA 0
    USB4 SELECT0 SELECT
    USB5 DATA 3
    USB6 DATA 2
    USB7 SELECT1 REQ
    USB8         ACK
    
    */
    
    int buttons = 0;
    int analog_x = 0;
    int analog_y = 0;
    int analog_l = -128;
    int analog_r = -128;
    
    int controller = 0; // 0 master system, 3 btn megadrive, 6 btn megadrive
                        // 4 saturn,        5 saturn 3d
    int controllerOld = 0;
    

  USB7 = 0;
  wait_us(1700);
  for (int i = 0; i < 8; i++)
  {
    if (i % 2 == 0) //nombre pair
    {
      USB7 = 0;
      wait_us(20);
      if (i == 2 && !USB4 && !USB5)
      {
        controller = 3; // Magadrive
      }
      if (i == 4 && !USB2 && !USB3)
      {
        controller = 6; // Megadrive 6 btn
      }
    }
    else //nombre impair
    {
      USB7 = 1;
      wait_us(20);
      if (i == 7 && !USB2 && !USB3 && USB6) // && USB5 && USB6)
      {
        controller = 4; // Saturn
        break;
      }
      if (i == 7 && !USB2 && USB3 && !USB6) // && !USB5 && !USB6)
      {
        controller = 5; // Saturn 3D
        break;
      }
      if (i == 5 && controller == 6 && controllerOld == 0 && !USB5) // Utile ou pas utile ????
      {
        controller = 3; // Magadrive
      }  
    }
  }
  
  switch (controller) {
    case 0: // Master system
        // Lecture des boutons
        if(!USB2) buttons |= UP;
        if(!USB3) buttons |= DOWN;
        if(!USB4) buttons |= LEFT;
        if(!USB5) buttons |= RIGHT;
        if(!USB6) buttons |= B;
        if(!USB8) buttons |= C;
        
      //buttons |= 16384;
      break;
    case 3: // Megadrive 3 btns
        USB7 = 0;
        wait_us(1700);
        if(!USB2) buttons |= UP;
        if(!USB3) buttons |= DOWN;
     // if(!USB4) buttons |= GND;
     // if(!USB5) buttons |= GND;
        if(!USB6) buttons |= A;
        if(!USB8) buttons |= START;
        USB7 = 1;
        wait_us(20);
        if(!USB2) buttons |= UP;
        if(!USB3) buttons |= DOWN;
        if(!USB4) buttons |= LEFT;
        if(!USB5) buttons |= RIGHT;
        if(!USB6) buttons |= B;
        if(!USB8) buttons |= C; 
        
      //buttons |= 32768;
      //getMegadrive3Buttons();
      //return controller;
      break;
    case 4: // Saturn
        //buttons = 2;
        // Lecture des boutons
        USB4.output();
        
        USB4 = 1;
        USB7 = 1;
        wait_us(100);
        
        USB4 = 0;
        USB7 = 1;
        wait_us(30);
        
        if(!USB5) buttons |= RIGHT;
        if(!USB6) buttons |= LEFT;
        if(!USB2) buttons |= DOWN;
        if(!USB3) buttons |= UP;
        
        USB4 = 1;
        USB7 = 0;
        wait_us(30);
        
        if(!USB5) buttons |= START;
        if(!USB6) buttons |= A;
        if(!USB2) buttons |= C;
        if(!USB3) buttons |= B;
        
        USB4 = 0;
        USB7 = 0;
        wait_us(30);
        
        if(!USB5) analog_r = 127;  // 8192
        if(!USB6) buttons |= X;
        if(!USB2) buttons |= Y;
        if(!USB3) buttons |= Z;
        
        USB4 = 1;
        USB7 = 1;
        wait_us(30);
        
        if(!USB5) analog_l = 127; // 4096
        
        //buttons |= 131072;
        
      break;
    case 5: // Saturn 3D
        //buttons = 4;
        int bite = 0;
        bool analog = false;
        
        USB4.output();
        
        USB4 = 0;
        wait_us(50);
        USB7 = 0;
  
        for (int i = 0; i <= 100; i++) {
            if(!USB8) break;
            wait_us(5);
        }
        
        if(USB3) analog = true;
        
        USB7 = 1;
        
        for (int i = 0; i <= 100; i++) {
            if(USB8) break;
            wait_us(5);
        }
        
        if(USB3) bite |= 1;
        if(USB2) bite |= 2;
        if(USB6) bite |= 4;
        if(USB5) bite |= 8;
        
        USB7 = 0;
        
        for (int i = 0; i <= 100; i++) {
            if(!USB8) break;
            wait_us(5);
        }
        
        if(!USB3) buttons |= UP;
        if(!USB2) buttons |= DOWN;
        if(!USB6) buttons |= LEFT;
        if(!USB5) buttons |= RIGHT;
        
        USB7 = 1;
        
        for (int i = 0; i <= 100; i++) {
            if(USB8) break;
            wait_us(5);
        }
        
        if(!USB3) buttons |= B;
        if(!USB2) buttons |= C;
        if(!USB6) buttons |= A;
        if(!USB5) buttons |= START;
        
        USB7 = 0;
        
        for (int i = 0; i <= 100; i++) {
            if(!USB8) break;
            wait_us(5);
        }
        
        if(!USB3) buttons |= Z;
        if(!USB2) buttons |= Y;
        if(!USB6) buttons |= X;
        if(!USB5) analog_r = 127;
        
        USB7 = 1;
        
        for (int i = 0; i <= 100; i++) {
            if(USB8) break;
            wait_us(5);
        }
        
        /*if(!USB3) buttons |= 4096;
        if(!USB2) buttons |= 8192;
        if(!USB6) buttons |= 16384;*/
        if(!USB5) analog_l = 127;
        
        if(bite == 6 && analog){
            
            analog_l = 0;
            analog_r = 0;
            
            USB7 = 0;
            
            for (int i = 0; i <= 100; i++) {
                if(!USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_x |= 16;
            if(USB2) analog_x |= 32;
            if(USB6) analog_x |= 64;
            if(USB5) analog_x |= 128;
            
            USB7 = 1;
            
            for (int i = 0; i <= 100; i++) {
                if(USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_x |= 1;
            if(USB2) analog_x |= 2;
            if(USB6) analog_x |= 4;
            if(USB5) analog_x |= 8;
            
            USB7 = 0;
            
            for (int i = 0; i <= 100; i++) {
                if(!USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_y |= 16;
            if(USB2) analog_y |= 32;
            if(USB6) analog_y |= 64;
            if(USB5) analog_y |= 128;
            
            USB7 = 1;
            
            for (int i = 0; i <= 100; i++) {
                if(USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_y |= 1;
            if(USB2) analog_y |= 2;
            if(USB6) analog_y |= 4;
            if(USB5) analog_y |= 8;
            
            USB7 = 0;
            
            for (int i = 0; i <= 100; i++) {
                if(!USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_r |= 16;
            if(USB2) analog_r |= 32;
            if(USB6) analog_r |= 64;
            if(USB5) analog_r |= 128;
            
            USB7 = 1;
            
            for (int i = 0; i <= 100; i++) {
                if(USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_r |= 1;
            if(USB2) analog_r |= 2;
            if(USB6) analog_r |= 4;
            if(USB5) analog_r |= 8;
            
            USB7 = 0;
            
            for (int i = 0; i <= 100; i++) {
                if(!USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_l |= 16;
            if(USB2) analog_l |= 32;
            if(USB6) analog_l |= 64;
            if(USB5) analog_l |= 128;
            
            USB7 = 1;
            
            for (int i = 0; i <= 100; i++) {
                if(USB8) break;
                wait_us(5);
            }
            
            if(USB3) analog_l |= 1;
            if(USB2) analog_l |= 2;
            if(USB6) analog_l |= 4;
            if(USB5) analog_l |= 8;
            
            analog_x = analog_x - 128;
            analog_y = analog_y - 128;
            analog_l = analog_l - 128;
            analog_r = analog_r - 128;
        
        }
        
        //buttons |= 262144;
        
      break;
    case 6: // Megadrive 6 btns
        USB7 = 0;
        wait_us(1700);
        
        USB7 = 1;
        wait_us(20);
        
        USB7 = 0;
        wait_us(20);
        if(!USB2) buttons |= UP;
        if(!USB3) buttons |= DOWN;
     // if(!USB4) buttons |= GND;
     // if(!USB5) buttons |= GND;
        if(!USB6) buttons |= A;
        if(!USB8) buttons |= START;
        USB7 = 1;
        wait_us(20);
        if(!USB2) buttons |= UP;
        if(!USB3) buttons |= DOWN;
        if(!USB4) buttons |= LEFT;
        if(!USB5) buttons |= RIGHT;
        if(!USB6) buttons |= B;
        if(!USB8) buttons |= C; 
        USB7 = 0;
        wait_us(20);
     // if(!USB2) buttons |= GND;
     // if(!USB3) buttons |= GND;
        USB7 = 1;
        wait_us(20);
        if(!USB2) buttons |= Z;
        if(!USB3) buttons |= Y;
        if(!USB4) buttons |= X;
        if(!USB5) buttons |= MODE;
        
      //buttons |= 65536; // 15
      //getMegadrive6Buttons();
      //return controller;
      break;
  }
  
    controllerOld = controller;
    int array[] = {analog_r, analog_l, analog_x, analog_y, buttons, 0};
    return array;
}

int *SegaDreamcast()    
{
    int array[] = {0, 0, 0, 0, 0, 0};
    return array;
}