/* ILI9341 interface for the NRF52832
 */

#include "mbed.h"
#include "display.h"
/* Serial */
#define BAUDRATE 9600
Serial g_Serial_pc(P0_18, P0_14, BAUDRATE);

/* DigitalOut */
#define LED_ON      0
#define LED_OFF     1

DigitalOut DataLED(A5, LED_OFF);

Display display;

uint32_t prbs()
{
    // This is an unverified 31 bit PRBS generator
    // It should be maximum length but this has not been verified 
    static uint32_t shift_register=0xaa551199;
    unsigned long new_bit=0;
    static int busy=0; // need to prevent re-entrancy here  
    if (!busy)
    {
        busy=1;
        new_bit= ((shift_register & (1<<27))>>27) ^ ((shift_register & (1<<30))>>30);
        new_bit= ~new_bit;
        new_bit = new_bit & 1;
        shift_register=shift_register << 1;
        shift_register=shift_register | (new_bit);
        busy=0;
    }
    return shift_register & 0x7ffffff; // return 31 LSB's 
}
uint32_t random(uint32_t lower,uint32_t upper)
{
    return (prbs()%(upper-lower))+lower;
}
int main(void) {
  
    int count;

   
    display.begin();
    while(1)    
    {
        DataLED = !DataLED;
        if (display.penDown()) 
        {
            display.print(display.readXTouch(),10,10,display.RGBToWord(0xff,0xff,0),display.RGBToWord(0,0,0));
            display.print(display.readYTouch(),80,10,display.RGBToWord(0xff,0xff,0),display.RGBToWord(0,0,0));
        }        
        display.drawRectangle(random(0,240),random(0,320),random(0,240),random(0,320),random(0,0xffff));                                
        //display.fillRectangle(random(0,240),random(0,320),random(0,240),random(0,320),random(0,0xffff));                   
        display.drawCircle(random(0,240),random(0,240),random(0,320),random(0,0xffff));
        //display.fillCircle(random(0,240),random(0,320),random(0,120),random(0,0xffff));
        count++;
        if (count >= 10) 
        {
            display.fillRectangle(0,0,SCREEN_WIDTH,SCREEN_HEIGHT,0);
            count = 0;
        }
        
    }

    return 0;
}
