// oled.h
// This class is for the SSD1306 OLED
// 
#include <mbed.h>
#include "font5x7.h"
I2C i2c(P0_30, P0_0); // SDA is on P0_30, SCL is on P0_0
class oled 
{

public: 
    oled() {};
    void clear()
    {
        for (int i = 0; i < 8; i++)
        {
            clearOLEDLine(i);
        }
    }
    void begin()
    {
        resetOLED();
        clear();
    }
    void print(int Col, int Row, const char *Text)
    {
        // write the supplied text (up to 25 bytes) to the given display line
        int i;
        uint8_t RowData[128];
        for (i = 0; i < 128; i++)
            RowData[i] = 0;
        while (*Text) {
            for (i = 0; i < FONT_WIDTH; i++)
            {
                RowData[Col * FONT_WIDTH + i] = Font5x7[FONT_WIDTH * ((*Text) - 32) + i];
            }
            Col++;
            Text++;
            if (Col > 24)
                break; // Can't print past end of the screen
        }
        writeOLEDLine(Row, RowData);
    }
    void print(int Col, int Row, int32_t Value)
    {
        char Text[20];
        int2Text(Text,Value);
        print(Col,Row,Text);
    }
   
private:
    void writeOLEDLine(int LineNumber, uint8_t *Values)
    {
        // Writes the set of values to the given line number
        writeOLEDRegister(0x00, 0x21);
        writeOLEDRegister(0x00, 0);
        writeOLEDRegister(0x00, 127);
        writeOLEDRegister(0x00, 0x22);
        writeOLEDRegister(0x00, LineNumber); // Page address
        writeOLEDRegister(0x00, 7);
        writeOLEDBytes(0x40, 128, Values);
    }
    uint8_t writeOLEDRegister(uint8_t RegNum, uint8_t Value)
    {
        char TXData[2];
        TXData[0] = RegNum;
        TXData[1] = Value;
        return i2c.write(0x3c << 1,(const char *)TXData,2);    
    }
    void resetOLED()
    {
        // Reset sequence got from https://github.com/adafruit/Adafruit_SSD1306/blob/master/Adafruit_SSD1306.cpp
        writeOLEDRegister(0x00, 0xae);
        writeOLEDRegister(0x00, 0xd5);
        writeOLEDRegister(0x00, 0x80);
        writeOLEDRegister(0x00, 0xa8);
        writeOLEDRegister(0x00, 63);
        writeOLEDRegister(0x00, 0xd3);
        writeOLEDRegister(0x00, 0);
        writeOLEDRegister(0x00, 0x40);
        writeOLEDRegister(0x00, 0x8d);
        writeOLEDRegister(0x00, 0x14);
        writeOLEDRegister(0x00, 0x20);
        writeOLEDRegister(0x00, 0x00);
        writeOLEDRegister(0x00, 0xa1);
        writeOLEDRegister(0x00, 0xc8);
        
        writeOLEDRegister(0x00, 0xda);
        writeOLEDRegister(0x00, 0x12);
        writeOLEDRegister(0x00, 0x81);
        writeOLEDRegister(0x00, 0xcf);
        
        writeOLEDRegister(0x00, 0xd9);
        writeOLEDRegister(0x00, 0xf1);
        writeOLEDRegister(0x00, 0xdb);
        writeOLEDRegister(0x00, 0x40);
        writeOLEDRegister(0x00, 0xa4);
        writeOLEDRegister(0x00, 0xa6);
        writeOLEDRegister(0x00, 0x2e);
        writeOLEDRegister(0x00, 0xaf);
    }
    void clearOLEDLine(int LineNumber)
    {
        // Clears the given line (range 0 to 7) on the display
        // A line is 8 pixels high
        writeOLEDRegister(0x00, 0x21);
        writeOLEDRegister(0x00, 0);
        writeOLEDRegister(0x00, 127);
        writeOLEDRegister(0x00, 0x22);
        writeOLEDRegister(0x00, LineNumber); // Page address
        writeOLEDRegister(0x00, 7);
        fillOLEDBytes(0x40, 128, 0x00);
    }
    
    
    uint8_t fillOLEDBytes(uint8_t RegNum, uint8_t Count, uint8_t Value)
    {
        // Repeatedly writes the given Value to the OLED memory - useful
        // for clearing the display
        uint8_t TXData[Count+1];    
        int i;
        TXData[0] = RegNum;
        for (i = 0; i < Count; i++)
        {
            TXData[i + 1] = Value;
        }
        return i2c.write(0x3c << 1,(const char *)TXData,Count+1);    
    }
    uint8_t writeOLEDBytes(uint8_t RegNum, uint8_t Count, uint8_t *Values)
    {
        // Writes the array of up to 128 bytes to the OLED display
        if (Count > 128)
            return -1;
        uint8_t TXData[Count+1];        
        int i;
        TXData[0] = RegNum;
        for (i = 0; i < Count; i++)
        {
            TXData[i + 1] = Values[i];
        }
        return i2c.write(0x3c << 1,(const char *)TXData,Count+1);    
    }

    
    void int2Text(char *Text, int32_t Value)
    {
        int index;
        Text[11]=0;
        if (Value < 0)
        {
            Text[0]='-';
            Value = -Value;
        }
        else
        {
            Text[0] = '+';
        }
        for (index = 0; index < 10;index++)
        {
            Text[10-index]=(Value % 10) + '0';
            Value = Value / 10;
        }   
    }
    void int2Hex(char *Hex, uint32_t Value)
    {
        int temp;
        int index;
        Hex[8]=0;
        for (index = 0; index < 8;index++)
        {
            temp = Value % 16;
            if (temp < 10)
                temp = temp + '0';
            else
                temp = temp + 'A' - 10;
            Hex[7-index]=temp;
            Value = Value / 16;
        }
    }
};
