/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "LEDService.h"
#include "accelService.h"
#include "oled.h"
#define enable_interrupts() asm(" cpsie i ")
#define disable_interrupts() asm(" cpsid i ")


DigitalOut myled(P0_29);

const static char     DEVICE_NAME[] = "CJMCU-8223";
static const uint16_t uuid16_list[] = {LEDService::LED_SERVICE_UUID,accelService::ACCEL_SERVICE_UUID};
accelService *AccelServicePtr;
LEDService *ledServicePtr;

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

/**
 * This callback allows the LEDService to receive updates to the ledState Characteristic.
 *
 * @param[in] params
 *     Information about the characterisitc being updated.
 */
void onDataWrittenCallback(const GattWriteCallbackParams *params) {
    if ((params->handle == ledServicePtr->getValueHandle()) && (params->len == 1)) {
        myled = *(params->data);
    }
}
void onDataReadCallback(const GattReadCallbackParams *params) {
    
}
/**
 * This function is called when the ble initialization process has failed
 */
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Initialization error handling should go here */
}

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);
    ble.gattServer().onDataRead(onDataReadCallback);
    bool initialValueForLEDCharacteristic = false;
    ledServicePtr = new LEDService(ble, initialValueForLEDCharacteristic);
    int16_t initialValue = 0;
    AccelServicePtr = new accelService(ble,initialValue);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(100); /* 100ms. */
    ble.gap().startAdvertising();
}
oled Oled;
int main(void)
{
 
    int Count=0;
    Oled.begin();
    Lis3dh.begin();
    Oled.print(0,0  ,"Hello");
    

    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    
    while (ble.hasInitialized()  == false) { 
        Oled.print(0,0,"BLE init fail");
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.1);
    
    /* spin loop */ }
    Oled.print(0,0,"BLE init done");
    while (true) {
        // update the values for the BLE interface
        AccelServicePtr->poll();
        int x,y,z;
        x = 1;
        y = 2;
        z = 3;        
        // show the values on the display
        if (Lis3dh.dataReady())        
        {
            Lis3dh.read(x,y,z);
            Oled.print(0,0,x/16);
            Oled.print(0,1,y/16);
            Oled.print(0,2,z/16);
        }
        ble.waitForEvent();
        
    }
}
