#include <mbed.h>
SPI spi(P0_6,P0_4,P0_7); // P0_4 = MISO, P0_6 = MOSI, P0_7 = SCK
DigitalOut LIS3D_CS(P0_3); // Chip select for the LIS3DH : When low SPI mode is enabled
DigitalIn int1(P0_1);
class lis3dh
{
public:
    lis3dh() {};    
    void begin()
    {
        LIS3D_CS = 1; // disable SPI mode for a moment
        spi.format(8,3);
        spi.frequency(400000);                        
        
        LIS3D_CS = 0; // 
        spi.write(0x1e); // Turn off internal pull-ups as we are using SPI to save power
        spi.write(0x90); 
        LIS3D_CS = 1; // 
        
        LIS3D_CS = 0; 
        spi.write(0x1f); // enable the temperature sensor and the ADC
        spi.write(0xc0);
        LIS3D_CS = 1; 
        
        LIS3D_CS = 0; 
        spi.write(0x20); // configure chip for 100Hz, high resolution, normal mode, all axes
        spi.write(0b01110111);
        LIS3D_CS = 1; 
        
        
        LIS3D_CS = 0; 
        spi.write(0x23); // Turn on HR mode
        spi.write(0x88);
        LIS3D_CS = 1;
        
        
        LIS3D_CS = 0; 
        spi.write(0x22); // Enable data ready output on INT1 (P0_1)
        spi.write(0x10);
        LIS3D_CS = 1; 
        
        

        
    }
    
    int who_am_i()
    {
        LIS3D_CS = 0; 
        // Send 0x8f, the command to read the WHOAMI register
        spi.write(0x8f);    
        // Send a dummy byte to receive the contents of the WHOAMI register
        int whoami = spi.write(0x00);
        LIS3D_CS = 1; 
        return whoami; // Should return 55 decimal or 33 Hex
    }
    
    int dataReady()
    {
        LIS3D_CS = 0; 
        // Send 0xa7, the command to read the status register (0x27)
        spi.write(0xa7);    
        // Send a dummy byte to receive the contents of the register
        int status = spi.write(0x00);
        LIS3D_CS = 1; // 
        /*if (status & 0x08)
            status = 1;
        else
            status = 0;
        */
        return int1; // return 1 if data ready
    }
    int read(int &X, int &Y, int &Z)
    {
        int16_t L,H;
        int16_t result;
        LIS3D_CS = 0; 
        // Send 0x8f, the command to read the WHOAMI register
        spi.write(0xe8);    
        // Send a dummy byte to receive the contents of the register
        L = spi.write(0x00);        
        // Send a dummy byte to receive the contents of the register
        H = spi.write(0x00);
        result = (H << 8) + L;
        X = result;
        
        // Send a dummy byte to receive the contents of the register
        L = spi.write(0x00);        
        // Send a dummy byte to receive the contents of the register
        H = spi.write(0x00);
        result = (H << 8) + L;
        Y = result;
        
        // Send a dummy byte to receive the contents of the register
        L = spi.write(0x00);        
        // Send a dummy byte to receive the contents of the register
        H = spi.write(0x00);
        result = (H << 8) + L;
        Z = result;
        
        LIS3D_CS = 1; 
        
        return 0;
    }     
    
private:

};
