/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_MAG_SERVICE_H__
#define __BLE_MAG_SERVICE_H__
#include <mbed.h>
// Accelerometer : LSM303
//I2C i2c(P0_30, P0_0); // SDA is on P0_30, SCL is on P0_0
const int LSM303_ADDRESS = (0x19<<1); 
//const int MMA8653_ID = 0x5a;
class MAGService {
public:
    const static uint16_t MAG_SERVICE_UUID = 0xfff3;
    const static uint16_t MAG_X_CHARACTERISTIC_UUID = 0x1;
    const static uint16_t MAG_Y_CHARACTERISTIC_UUID = 0x2;
    const static uint16_t MAG_Z_CHARACTERISTIC_UUID = 0x3;

    MAGService(BLEDevice &_ble, int16_t initialValueForMAGCharacteristic) :
        ble(_ble), MagX(MAG_X_CHARACTERISTIC_UUID, &initialValueForMAGCharacteristic),MagY(MAG_Y_CHARACTERISTIC_UUID, &initialValueForMAGCharacteristic),MagZ(MAG_Z_CHARACTERISTIC_UUID, &initialValueForMAGCharacteristic)
    {
        GattCharacteristic *charTable[] = {&MagX,&MagY,&MagZ};
        GattService         MagService(MAG_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(MagService);
        // Wake the accelerometer from sleep mode by writing disabling low power mode, setting freq to 10Hz and enabling all three axes
        char Data[8]; // Declare a buffer for data transfer    
        int Status;
        Data[0]=0x20;   // wake up LSM303 (max speed, all accel channels)
        Data[1]=0x77;
        Status = i2c.write(LSM303_ADDRESS,Data,2);  // Write data to register   
       
        Data[0]=0x23;   // enable high resolution mode
        Data[1]=0x0e; 
        Status = i2c.write(LSM303_ADDRESS,Data,2);  // Write data to register   
    }

    GattAttribute::Handle_t getValueHandle() const {
        return MagX.getValueHandle();
    }
    void updateMagX(uint16_t newValue) {
        ble.gattServer().write(MagX.getValueHandle(), (uint8_t *)&newValue, sizeof(uint16_t));
    }
    void updateMagY(uint16_t newValue) {
        ble.gattServer().write(MagY.getValueHandle(), (uint8_t *)&newValue, sizeof(uint16_t));
    }
    void updateMagZ(uint16_t newValue) {
        ble.gattServer().write(MagZ.getValueHandle(), (uint8_t *)&newValue, sizeof(uint16_t));
    }
    void poll()
    {
        char Data[8]; // Declare a buffer for data transfer    
        int Status;
        int16_t X;
                         
        // Modify to suit your chip:
        // Goal get X,Y and Z readings off magnetometer.
        Data[0]=0x80 + 0x28; // Register number 0x28 has the X data (2 bytes)
        Status = i2c.write(LSM303_ADDRESS,Data,1,true);  // Write register number
        Status = i2c.read(LSM303_ADDRESS,Data,2); // Read register contents
        X = Data[1];
        X = (X << 8) + Data[0];
        
        int16_t Y;
        Data[0]=0x80 + 0x2a; // Register number 0x2a has the Y data (2 bytes)
        Status = i2c.write(LSM303_ADDRESS,Data,1,true);  // Write register number
        Status = i2c.read(LSM303_ADDRESS,Data,2); // Read register contents
        Y = Data[1];
        Y = (Y << 8) + Data[0];
        
        int16_t Z;
        Data[0]=0x80 + 0x2c; // Register number 0x2c has the Z data (2 bytes)
        Status = i2c.write(LSM303_ADDRESS,Data,1,true);  // Write register number
        Status = i2c.read(LSM303_ADDRESS,Data,2); // Read register contents
        Z = Data[1];
        Z = (Z << 8) + Data[0];
        
        updateMagX(X);
        updateMagY(Y);
        updateMagZ(Z);        
        
    }
private:
    BLEDevice &ble;
    ReadOnlyGattCharacteristic<int16_t>  MagX;
    ReadOnlyGattCharacteristic<int16_t>  MagY;
    ReadOnlyGattCharacteristic<int16_t>  MagZ;
};

#endif /* #ifndef __BLE_ACCEL_SERVICE_H__ */
