/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

//declaracion de estados
#define APAGADO 0
#define ENCENDIDO 1

//Entradas o eventos del sistema
unsigned char C = 0;

//Interrupcion recurrente
Ticker nombre_del_ticker;

//Salida del sistema
DigitalOut led_rojo(LED1);

//funcion con llamado recurrente
void funcion (){
    C++; //C = C + 1; C += C;
}

void maquina_estado(){
    static unsigned char estado = APAGADO;

    switch(estado)
    {
        default:
            estado = APAGADO;
            break;
            
        case APAGADO:
            //entrada
            if( C > 2 )
            {
                //salidas
                led_rojo = 0;   //pin a GND = LED ENCENDIDO
                C = 0;
                //transicion
                estado = ENCENDIDO;
                printf("S1::APAGADO -> S2::ENCENDIDO\r\n");
            }        
            break;
            
        case ENCENDIDO:
            //entrada
            if( C > 3 )
            {
                //salidas
                led_rojo = 1;   //pin a VCC = LED APAGADO
                C = 0;
                //transicion
                estado = APAGADO;
                printf("S2::ENCENDIDO -> S1::APAGADO\r\n");
            }        
            break;
    }
}

int main() {
    //Inicializaciones
    nombre_del_ticker.attach(&funcion, 1s);
    
    //lazo o loop infinito
    while(1){
        maquina_estado();
    }
}

