#include "mbed.h"
#include "SDFileSystem.h"
#include <wave_player.h>

#define PC_BAUD   9600

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd", PTE6, SDFileSystem::SWITCH_POS_NO, 25000000);
Serial pc(USBTX,USBRX);

AnalogOut DACout(PTE30);
wave_player waver(&DACout);


int main() 
{
    //Configure CRC, small frames, and write validation
    sd.crc(true);
    sd.large_frames(false);     // SPI 16 bits not supported ???  
    sd.write_validation(true);
    
    //waver.set_verbosity(1);
    FILE *wave_file;
    pc.baud(PC_BAUD);
    printf("\n\r\n\rGoing to open a file...\n\r");
    wave_file=fopen("/sd/sp.wav","r");
    printf("Opened a file. Will now play.\n\r");
    waver.play(wave_file);
    printf("Did it play?\n\r");
    fclose(wave_file); 
}