/*
#ifndef __TIMER__
#define __TIMER__


void initTimer(int Id, int timeout);

#endif

*/




#ifndef INC_TIMERS_H_
#define INC_TIMERS_H_


#include "mbed.h"

#define null 0
//#define true 1
//#define false 0

//#include "lpc_types.h"
//#include "cyblib.h"
//#include "stdlib.h"

    
    typedef enum
    {
        autoReloadTimer = 0,
        oneShotTimer = 1,
    }Timer_option;


    typedef struct TimerElement
    {
        struct TimerElement *next;
        struct TimerElement *prev;
        int nb_ms;
        int oldTick;
        int Id;
        Timer_option option;
    }TimerElement;

    typedef struct Timers_Buffers
    {
        TimerElement *first;
        int count;
        int lastCall;
    }Timers_Buffer;

    
    /*=======================================================================
     *
     *=======================================================================*/
    void inittimerBuffer();

    /*
     * Id: identifiant de timer
     * nbMsTimer: durée en ms
     * option: autoReloadTimer/oneShotTimer
     * */
    void initTimer();
    void startTimer(int Id, int nbMsTimer, Timer_option option);
    bool IsTimerElapsed(int Id);
    void killTimer(int Id);
    void ResetTimer(int Id);
    bool Wait2(int Id, int nbMs);


#endif /* INC_TIMERS_H_ */
