#include "timer.hpp"


//définition des timers.
Timer timer1; 
//déclaration des differantes taches
void task1_switch(void);
//declaration des differantes interuption timer
Ticker __time_up113213132; //definition du Ticker, avec le nom “time_up1”
static int _nbTick = 0;
static int _nbTickMax = 0;
Timers_Buffer _timers;

#define NBTIMERS 10
int WaitTimers[NBTIMERS];

int _Wait2Step = 0;
bool Wait2(int Id, int nbMs)
{
    switch(_Wait2Step)
    {
        case 0:
            initTimer();
            _Wait2Step = 1;
            break;
        case 1:
            startTimer(Id, nbMs, oneShotTimer);
            _Wait2Step = 2;
            break;
        
        case 2:
            if(true == IsTimerElapsed(Id))
            {
                _Wait2Step = 1;
                return true;
            }
            break;
    }
    return false;
}

////////////////////////////////////////
//                TASKS1              //
////////////////////////////////////////
void initTimer()
{
    //_nbTickMax = timeout;
    __time_up113213132.attach(&task1_switch, 0.001);//initialisation du ticker a 1Khz "1ms". 

}


static void task1_switch()
{ 
    
    _nbTick++;
    
}


int getTickValue()
{
    return _nbTick;
}
 
void inittimerBuffer()
{
    _timers.count = 0;
    _timers.first = null;
}

/*
 * Id: identifiant de timer
 * nbMsTimer: durée en ms
 * option: autoReloadTimer/oneShotTimer
 * */
void startTimer(int Id, int nbMsTimer, Timer_option option)
{
    int i;
    TimerElement *current;
    _timers.lastCall = _nbTick; // enregistre le dernier acces a la stucture
    if(_timers.count == 0) // pas de timer
    {
        _timers.first = (TimerElement *)malloc(sizeof(TimerElement));
        _timers.first->Id = Id;
        _timers.first->nb_ms = nbMsTimer;
        _timers.first->oldTick = getTickValue();
        _timers.first->prev = null;
        _timers.first->next = null;
        _timers.first->option = option;
        _timers.count ++;
    }
    else
    {
        current = _timers.first;
        for(i=0; i<_timers.count; i++)
        {
            if(current->Id == Id)
            {
                // trouvé => mis a jour
                _timers.first->oldTick = getTickValue();
            }
            if(i != _timers.count-1)
            current = current->next;
        }

        // pas trouvé => ajout
        current->next = (TimerElement *)malloc(sizeof(TimerElement));
        current->next->Id = Id;
        current->next->prev = current;
        current->next->next = null;
        current->next->nb_ms = nbMsTimer;
        current->next->oldTick = getTickValue();
        current->next->option = option;
        _timers.count ++;
    }
}

static void removeTimerElement(TimerElement *current);
static void removeTimerElement(TimerElement *current)
{
    if(_timers.count == 0) return;
    if(_timers.count == 1) // 1 timer
    {
        _timers.first = null;
        _timers.lastCall = 0;
    }
    else if(current->prev == null) // premier de la liste
    {
        _timers.first = current->next;
        _timers.first->prev = null;
    }
    else if(current->next == null) // dernier de la liste
    {
        current->prev->next = null;
    }
    else
    {
        current->prev->next = current->next;
        current->next->prev = current->prev;
    }
    free(current);
    _timers.count --;
}

bool IsTimerElapsed(int Id)
{
    TimerElement *current;
    int i;
    if(_timers.count == 0) return false;
    current = _timers.first;
    for(i=0; i<_timers.count; i++)
    {
        if(current->Id == Id)
        {
            // trouvé => retour valeur
            if(getTickValue() > (current->oldTick + current->nb_ms))
            {
                switch(current->option)
                {
                    case oneShotTimer:
                        removeTimerElement(current);
                        break;
                    case autoReloadTimer:
                        current->oldTick = getTickValue();
                        break;
                }
                return true;
            }
        }
        if(i != _timers.count-1)
        current = current->next;
    }
    return false;
}

void killTimer(int Id)
{
    TimerElement *current;
    int i;
    if(_timers.count == 0) return;
    current = _timers.first;
    for(i=0; i<_timers.count; i++)
    {
        if(current->Id == Id)
        {
            // trouvé => suppression
            removeTimerElement(current);
            return;
        }
        current = current->next;
    }
}

void ResetTimer(int Id)
{
    TimerElement *current;
    int i;
    if(_timers.count == 0) return;
    current = _timers.first;
    for(i=0; i<_timers.count; i++)
    {
        if(current->Id == Id)
        {
            // trouvé => reset
            current->oldTick = getTickValue();
            return;
        }
        current = current->next;
    }
}
