////////////////////////////////////////////////////////////////////////////
//rajout du spi1(p5, p6, p7, p8)--------( 14 / 11 / 2017 ) task5
//rajout de la conversion AD p20--------( 15 / 11 / 2017 ) task6  
//rajout fonction generation trajectoire a tester "il y as un probleme de position final lorsque on change "slope_time"
//rajout en task2 visualisation des pulses avec "telemetry viewer v0.4" 
//rajout afficheur nextion nx8048t050_011 ---------(  05 / 10 / 2019  )

#include "mbed.h"
#include "qeihw.h"
#include "NVIC_set_all_priorities.h"
#include "timer.hpp"
#include "NextionLCD.h"

char c ;//commande moteur 

//declaration des leds visuelle utiliser pour mesurer le temps des taches 
DigitalOut myled1(LED1);
DigitalOut myled3(LED3);

// Define buttons
DigitalIn input4(p19);
DigitalIn input3(p18);
DigitalIn input2(p17);
//DigitalIn input1(p16);
InterruptIn input1(p16);

//declaration des variables afficheur 

#define BLACK   0 
#define BLUE    31
#define BROWN   48192
#define GREEN   2016
#define YELLOW  65504
#define RED     63488
#define GRAY    33840
#define WHITE   65535

 typedef struct ButtonCommand
{
    char IsNewCommandAvailable;
    char IsButtonPressed;
    char cmdNb;
    char buttonId;
    char data1;
    char data2;
    char var1;
}ButtonCommand;

typedef enum
{
    ButtonCmd = 0x65,//Touch event return data   
    PageCmd = 0x66,//Current page ID number returns
    TouchCmd = 0x67,//Touch coordinate data return
    TouchEentCmd = 0x68,//Touch Event in sleep mode
    StringDataCmd = 0x70,//String variable data returns
    NumericDataCmd = 0x71,//Numeric variable data returns
    SleepModeCmd = 0x86,//Device automatically enters into sleep mode
    WakeUpCmd = 0x87,//Device automatically wake up
    StartUpCmd = 0x88,//System successful start up
    StartSDCmd = 0x89,//Start SD card upgrade
    DataTTRCmd = 0xfe,//Data transparent transmit ready
     
}CommandNb;

typedef enum
{
    Page0 = 0x00,
    Page1 = 0x01,   
    Page2 = 0x02,
    Page3 = 0x03,
    Page4 = 0x04,
    Page5 = 0x05,
    Page6 = 0x06,
    Page7 = 0x07,
}PageNb;

typedef enum
{
    Invalid_instruction = 0x0,
    Successful_execution_of_instruction = 0x01,
    Page_ID_invalid = 0x03,
    Picture_ID_invalid = 0x04,
    Font_ID_invalid = 0x05,
    Baud_rate_setting_invalid = 0x11,
    Curve_control_ID_number_or_channel_number_is_invalid = 0x12,
    Variable_name_invalid = 0x1a,
    Variable_operation_invalid = 0x1b,
    Failed_to_assign = 0x1c,
    Operate_PERFROM_failed = 0x1d,
    Parameter_quantity_invalid = 0x1e,
    IO_operate_failed = 0x1f,
    
}ErrorNb;

ButtonCommand buttonCmd;
char Cmd;
bool newCmdAvailable = false;
PageNb CurrentPageNb = Page0;
   
// déclaration du hardware
Serial pc(USBTX, USBRX);//utilisation de la liaison usb
 
QEIHW qei(QEI_DIRINV_NONE, QEI_SIGNALMODE_QUAD, QEI_CAPMODE_4X, QEI_INVINX_NONE );

Serial device(p9, p10);// tx, rx.//definition de la liaison rs232

DigitalOut frein_moteur1(p15); //changement momentané pour le projet r2d de p5 a p15

DigitalOut sens_rotation_moteur1(p13);
   
PwmOut PWM1(p21);
 
SPISlave spi1(p5, p6, p7, p8); // mosi, miso, sclk, ssel

AnalogIn Ain(p20);    
 
// définition des timers.
//Timer timer1;  
Timer timer2;  

//definition  spi1
int reply = 0xAAAA;// en bin "1010101010101010"
int valueFromMaster;

int Spi_val_RX[10]={0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};//buffer reception données SPI
int Spi_val_TX[10]={0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};//buffer transmission données SPI

// définition des sorties leds
DigitalOut led1(LED1);
DigitalOut led3(LED3);

bool home_done_tag;//tag pour savoir si la home es faite 

int t ;
int x=0 ;

float PI=3.141592653589793;

//vitesse moteur 
int vitesse_actuelle;

//position codeur en pulses 2000pulses/rotation 
int position_actuelle;//position du codeur
int position_actuelle_n1;//position du codeur a n-1
int position_home;
int position_sortie_capteur_de_home;
int position_initial;//position a l'alumage de la machine 
 
//données mecanique & moteur 
float J=3.375*1e-5;//0.005;//inertie en kg.m²
float K=0.05;//2;//constante de couple  N.m/v
float R=5;//K;//resistance du moteur en Ohms
float Umax=24;//24vdc tension max en volts

//parametres reglage
float dt_vit(5*1e-4);
float Ki=12;//default value=10;
float Kp;
float Kv;
float K_sw(K);
float tau;
float taud=(10*dt_vit);
float r1=3;//default value=2.5;derniere valeur =3
float r2=r1;//default value=2.5;

//variables generateur de consigne///////////////////////////////////////////////////////////////////////////////////////////
float Teta_debut, Teta_fin, Teta_diff;
float delta_Teta;
float consigne;//en pulse 
float slope_time(1.);//en seconde
bool start_slope(false);//flag debut de montee
int ticks_total;
int count_ticks;
int count_slope(0);
int count_max(0);

//variables calcul de l'asservissement en vitesse et position 
float Tetaco; //valeur de la consigne position en radians
float Tetam;//valeur mesuree de la position en radians

float dTetam;
float integ;
float A;

float dTetam_n1;
float Tetaco_n1;
float Tetam_n1;
float integ_n1;
float cyclic;
int signe_rot;

//variable ADC
float ADCdata;
float imax=1.8;
int result;
//declaration des differantes taches
void task1_switch(void);
void task2_switch(void);
void task3_switch(void);
void task4_switch(void);
void task5_switch(void);
void task6_switch(void);
void task7_switch(void);
void task8_switch(void);

//declaration des differantes interuption timer
Ticker time_up1; //definition du Ticker, avec le nom “time_up1”
Ticker time_up2; //definition du Ticker, avec le nom “time_up2”
Ticker time_up3; //definition du Ticker, avec le nom “time_up3”
Ticker time_up4; //definition du Ticker, avec le nom “time_up4”
Ticker time_up5; //definition du Ticker, avec le nom “time_up5”
Ticker time_up6; //definition du Ticker, avec le nom “time_up6”
Ticker time_up7; //definition du Ticker, avec le nom “time_up7”
Ticker time_up8; //definition du Ticker, avec le nom “time_up8”

//declaration des variables afficheur 
char mRxMsg[40];
int mRxIdx;
char charac;  
bool mTouch;
int mTouchX, mTouchY;

int val_temp;//valleur temporaire
int val_temp1;//valleur temporaire

////////////////////////////////////////////////////////////
//            fonction affichage sur nextion              // 
////////////////////////////////////////////////////////////

bool Touch(void) {
    return mTouch;
}

int TouchX(void) {
    return mTouchX;
}

int TouchY(void) {
    return mTouchY;
}

 bool lectureRSlcd(void)
{
    if(device.readable())
    { 
        charac = device.getc(); 
        mRxMsg[mRxIdx] = charac;
        mRxIdx++;
        if ((mRxIdx >= 3) && (mRxMsg[mRxIdx-1] == 0xff) && (mRxMsg[mRxIdx-2] == 0xff) && (mRxMsg[mRxIdx-3] == 0xff)) //valid rx message
        { 
          mRxIdx=0;
        
            if(mRxMsg[0] == 0x67) //Touch coordinate data return
             {   mTouchX = (mRxMsg[1]*256) + mRxMsg[2];
                mTouchY = (mRxMsg[3]*256) + mRxMsg[4];
                if(mRxMsg[5] == 0x01)
                    mTouch = true; 
                else
                    mTouch = false;
             }
        }
    }
 return mTouch;    
 }
 
//lecture de la donnée val  d une reponse de  sliders 
 int lecture_slider_RS_lcd(void)
{
    if(device.readable())
    { 
        charac = device.getc(); 
        mRxMsg[mRxIdx] = charac;
        mRxIdx++;
        if ((mRxIdx >= 3) && (mRxMsg[mRxIdx-1] == 0xff) && (mRxMsg[mRxIdx-2] == 0xff) && (mRxMsg[mRxIdx-3] == 0xff)) //valid rx message
        { 
          mRxIdx=0;
        
            if(mRxMsg[0] == 0x71) //sliders data return
             {   
                val_temp=mRxMsg[1];
             }
        }
   }
    return val_temp; 
 }

//recuperation de la valeur val du sliders h0 
//example : get_val(0);
void get_val(int n)
{  
 device.printf("get h%d.val %c%c%c",n, 0xff, 0xff, 0xff);//recuperation de la valeur val du sliders h0
}
//fonction general recuperation de la valeur val de h0 
void get_val_h0()
{  
 device.printf("get h0.val %c%c%c", 0xff, 0xff, 0xff);//recuperation de la valeur val du sliders h0
}

////////////////////////////////////////
//    Convertion pulses to radians    //
////////////////////////////////////////

//PI =3.141592653589793 =1000 pulses codeurs
float pulsesToRadians(int pulses) 
{
  float radians_VAL;
  radians_VAL=(pulses*PI)/1000.;
  return radians_VAL;
};

////////////////////////////////////////
//   calcule de la vitesse angulaire  //
////////////////////////////////////////

// ici le code du calcule pas encore fait !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// Convert ASCII string to unsigned 32-bit decimal "string is null-terminated"
  unsigned long Str2UDec(unsigned char string[]){
  unsigned long i = 0;  // index
  unsigned long n = 0;  // number
  while(string[i] != 0){
    n = 10*n +(string[i]-0x30);
    i++;
  }
  return n;
}

/////////////////////////////////////////////////////////////////////////////
//                   declaration de la fonction moteur1                    //
/////////////////////////////////////////////////////////////////////////////

void motor1_mouve(int position1,int T1,int position2,int T2,int position3,int T3)
{

/////////////////////////////////////////////////////////////////////
//               mouvement   trapezoide  non tésté                 //
/////////////////////////////////////////////////////////////////////
/*
    timer1.start(); // déclenchement du timer1 
    timer2.start(); // déclenchement du timer2
//ACC      
    consigne=position1 ;                                 
    slope_time=T1;
    start_slope=true;
    //do{} while (timer1.read_ms()!=T1);
    do{} while (timer1.read_ms()<T1);
    if (timer1.read_ms()>T1) // lecture du temps du timer1 en ms
    { 
      //device.printf("TIME out T1 ms \r\n");
      device.printf("t0.txt=\"time1out\"%c%c%c", 0xff, 0xff, 0xff); 
    } 

    timer1.reset(); // remise à zéro du timer1
//vmax  
    timer1.start(); // déclenchement du timer1 
    consigne=position2 ;                                 
    slope_time=T2;
    start_slope=true;
   //do{} while (timer1.read_ms()!=T2);
   do{} while (timer1.read_ms()<T2);
    if (timer1.read_ms()>T2) // lecture du temps du timer1 en ms
    { 
      //device.printf("TIME out T2 ms \r\n");
      device.printf("t0.txt=\"time2out\"%c%c%c", 0xff, 0xff, 0xff); 
    } 
    timer1.reset(); // remise à zéro du timer1
//DCC
    timer1.start(); // déclenchement du timer1 
    consigne=position3 ;                                 
    slope_time=T3;
    start_slope=true;
   //do{} while (timer1.read_ms()!=T3);
   do{} while (timer1.read_ms()<T3);
    if (timer1.read_ms()>T3) // lecture du temps du timer1 en ms
    { 
      //device.printf("TIME out T3 ms \r\n");
      device.printf("t0.txt=\"time3out\"%c%c%c", 0xff, 0xff, 0xff); 
    } 
    timer1.reset(); // remise à zéro du timer1

    if (timer2.read_ms()>(T1+T2+T3)) // lecture du temps du timer1 en ms
    { 
      //device.printf("TIME out  motor  \r\n");
      device.printf("t0.txt=\"timeMout\"%c%c%c", 0xff, 0xff, 0xff); 
    }      

timer2.reset(); // remise à zéro du timer2
*/
};

//////////////////////////////////////////////////////////////////////////////////////////
//                         declaration des differantes pages                            //
//////////////////////////////////////////////////////////////////////////////////////////

void page0()//code de la page : 6600ffffff
{
    
//device.printf("cls RED %c%c%c", 0xff, 0xff, 0xff); //clear screen color red fonnctionne pas ??
//device.printf("rest%c%c%c", 0xff, 0xff, 0xff);//y as un bug toute les commande prochine fonctionne plus ???
//wait_ms(10);

//device.printf("page %d%c%c%c",0x0, 0xff, 0xff, 0xff);// saut a la page0------sy
//wait_ms(10);
device.printf("t0.txt=\"position\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy 
device.printf("t6.txt=\"soft V0.014\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5); 
device.printf("b13.txt=\"flyready\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5); 
device.printf("b12.txt=\"BREAK\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5); 
device.printf("b11.txt=\"LANDING\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5);
device.printf("b21.txt=\"Quantum\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5);

device.printf("b18.txt=\"Speed M\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5);
device.printf("b19.txt=\"couple M\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5);
device.printf("b20.txt=\"Afterburner\"%c%c%c", 0xff, 0xff, 0xff);//affiche la version soft -------sy
//wait_ms(5);

//device.printf("b0.pic=17%c%c%c", 0xff, 0xff, 0xff);//chager l image du bouton b0 par l image n°17------sy
//wait_ms(10);
//device.printf("ref b0%c%c%c", 0xff, 0xff, 0xff);//rafrechir b0--------------sy

//wait_ms(10);
 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////             
             //FLY READY switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x19)&&(mRxMsg[3] == 0x01))
             { 
                //keyboard.printf("r");//flight ready
             }//uniquement le bouton allumeras la led 1 en release ---------------SY
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////              
             //space break switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x18)&&(mRxMsg[3] == 0x01))//press
             { 
             //keyboard.printf("x");//spacebreak
             //wait(0.5);
              while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("x");//spacebreak
                      //wait(0.035);
              }
             }//uniquement le bouton allumeras la led 2 en press event ---------------SY
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////               
             //LANDING switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x17)&&(mRxMsg[3] == 0x01))
             {
             //keyboard.printf("n");//landing mode 
             }//uniquement le bouton home allumeras la led 3 en release ---------------SY
             
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////                           
             //strafe up switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x13)&&(mRxMsg[3] == 0x01))//press
             {
             //keyboard.printf(" ");//strafe up
             //wait(0.5);
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf(" ");//strafe up
                      //wait(0.035);
              }
 
             }//uniquement le bouton allumeras la led 4 en release ---------------SY
             
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////              
             //strafe down switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x14)&&(mRxMsg[3] == 0x01))//press
             {
              //keyboard.keyCode(KEY_CTRL);//strafe down
              //wait(0.5);             
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.keyCode(KEY_CTRL);//strafe down
                      //wait(0.035);
              }             
                           
             }//uniquement le bouton allumeras la led 4 en release ---------------SY
             
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
             //forward switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x02)&&(mRxMsg[3] == 0x01))//press
             {
              //keyboard.printf("w");//vers l'avant
              //wait(0.5);
             
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("w");//vers l'avant
                      //wait(0.035);
              } 

             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////              
             //rearward switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x01)&&(mRxMsg[3] == 0x01))//press
             {
              //keyboard.printf("s");//vers l arriere
              //wait(0.5);             
             
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("s");//vers l arriere
                      //wait(0.035);
              } 
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
             //Right switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x03)&&(mRxMsg[3] == 0x01))//press
             {
              //keyboard.printf("d");//vers la droite
              //wait(0.5);

            while (mRxMsg[3]!=0x00)
            {
                //lectureRSlcd();
                //keyboard.printf("d");//vers la droite
                //wait(0.035);
            }
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
             //Left switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x04)&&(mRxMsg[3] == 0x01))//press
             {
             
             //keyboard.printf("a");//vers la gauche
             //wait(0.5);
             
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("a");//vers la gauche
                      //wait(0.035);
              } 
              
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
             //roll left switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1a)&&(mRxMsg[3] == 0x01))//press
             {
              //keyboard.printf("e");//rouli gauche
              //wait(0.5);             
             
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("e");//rouli gauche
                      //wait(0.035);
              } 
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
             //roll Right switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x05)&&(mRxMsg[3] == 0x01))//press
             {
                   
             //keyboard.printf("q");//rouli droit
             //wait(0.5);
                          
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("q");//rouli droit
                      //wait(0.035);
              } 
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
             //tangage vers le bas  switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1b)&&(mRxMsg[3] == 0x01))//press
             {
             
              //keyboard.printf("");//touche non affecté 
              //wait(0.5);
                                        
            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("");//touche non affecté la touche non connue
                      //wait(0.035);
              }              
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
            //tangage vers le haut  switch
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1b)&&(mRxMsg[3] == 0x01))//press
             {

              //keyboard.printf("");//touche non affecté  la touche non connue
              //wait(0.5);

            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("");//touche non affecté
                      //wait(0.035);
              }              
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY
             


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
            //quantum drive
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1f)&&(mRxMsg[3] == 0x01))//press
             {

              //keyboard.printf("b");//touche non affecté  la touche non connue
              //wait(0.5);

            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("b");//touche non affecté
                      //wait(0.035);
              }              
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
            //Speed M
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1c)&&(mRxMsg[3] == 0x01))//press
             {

              //keyboard.printf("c");//touche non affecté  la touche non connue
              //wait(0.5);

            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("c");//touche non affecté
                      //wait(0.035);
              }              
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
            //Speed M
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1c)&&(mRxMsg[3] == 0x01))//press
             {

              //keyboard.printf("b");//touche non affecté  la touche non connue
              //wait(0.5);

            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.printf("c");//touche non affecté
                      //wait(0.035);
              }              
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
            //Afterburner
          if((mRxMsg[0] == 0x65)&&(mRxMsg[1] == 0x00)&&(mRxMsg[2] == 0x1c)&&(mRxMsg[3] == 0x01))//press
             {

              //keyboard.keyCode(KEY_SHIFT);
              //wait(0.5);

            while (mRxMsg[3]!=0x00)
              {
                      //lectureRSlcd();
                      //keyboard.keyCode(KEY_SHIFT);
                      //wait(0.035);
              }              
             
             }//uniquement le bouton  allumeras la led 4 en release ---------------SY


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

//ici il faut completer le code pour pouvoir detecter le bon bouton en press event et release event
//example le bouton start  press event 65 01 01 01 ff ff ff  et en release event 65 01 01 00 ff ff ff . rem:code touche repris par simulation avec le soft nextion 

}
 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page1******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void page1()//code de la page : 6601ffffff
{
device.printf("bt0.txt=\"BREAK1\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy    
}
 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page2******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void page2()//code de la page : 6602ffffff
{
device.printf("b0.txt=\"BREAK2\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton b0 -------sy 
//get_val(3);//donner l'ordre d envoyer la valeur val de h3
//int valeur_val=lecture_slider_RS_lcd();//recuperation de la valeur val de h3
//device.printf("n3.val=%d %c%c%c", valeur_val, 0xff, 0xff, 0xff);//affiche le nombre sur n1 -------sy
//device.printf("z0.val=%d %c%c%c", valeur_val, 0xff, 0xff, 0xff);//affiche le nombre sur z0 gauge -------sy
}
  
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page3******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void page3()//code de la page : 6603ffffff
{
device.printf("t0.txt=\"BREAK3\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton b19 -------sy     
}
   
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page4******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void page4()//code de la page : 6604ffffff
{
device.printf("t0.txt=\"BREAK4\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy

//    get_val_h0();
//    val_temp1=lecture_slider_RS_lcd();//recuperation de la valeur du sliders h0 dans val_temp
//    device.printf("n1.val=%d %c%c%c", val_temp1, 0xff, 0xff, 0xff);//affiche le nombre sur n1 -------sy
 
}   

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page5******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void page5()//code de la page : 6605ffffff
{
//device.printf("t0.txt=\"BREAK5\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
//device.printf("t1.txt=\"500ms/div\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
//device.printf("g0.txt=\"position M\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy 
device.printf("add 1,0,%d%c%c%c", (position_actuelle/500), 0xff, 0xff, 0xff);// pour la fonction waveform add id1,chanel0,position actu
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page6******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
void page6()//code de la page : 6606ffffff
{
//device.printf("t1.txt=\"courant\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy 
//device.printf("t0.txt=\"position\"%c%c%c", 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
device.printf("add 2,0,%d%c%c%c", (position_actuelle/500), 0xff, 0xff, 0xff);// pour la fonction waveform add id1,chanel0,position actu
}    

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************page7******************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
void page7()//code de la page : 6607ffffff
{
        device.printf("t0.txt=\"%x\"%c%c%c", mRxMsg[0], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy 
        device.printf("t1.txt=\"%x\"%c%c%c", mRxMsg[1], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t2.txt=\"%x\"%c%c%c", mRxMsg[2], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t3.txt=\"%x\"%c%c%c", mRxMsg[3], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t4.txt=\"%x\"%c%c%c", mRxMsg[4], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t5.txt=\"%x\"%c%c%c", mRxMsg[5], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t6.txt=\"%x\"%c%c%c", mRxMsg[6], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t7.txt=\"%x\"%c%c%c", mRxMsg[7], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy 
        device.printf("t8.txt=\"%x\"%c%c%c", mRxMsg[8], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t9.txt=\"%x\"%c%c%c", mRxMsg[9], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t10.txt=\"%x\"%c%c%c", mRxMsg[10], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t11.txt=\"%x\"%c%c%c", mRxMsg[11], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t12.txt=\"%x\"%c%c%c", mRxMsg[12], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t13.txt=\"%x\"%c%c%c", mRxMsg[13], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t15.txt=\"%x\"%c%c%c", mRxMsg[14], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t16.txt=\"%x\"%c%c%c", mRxMsg[15], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t17.txt=\"%x\"%c%c%c", mRxMsg[16], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t18.txt=\"%x\"%c%c%c", mRxMsg[17], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t19.txt=\"%x\"%c%c%c", mRxMsg[18], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t20.txt=\"%x\"%c%c%c", mRxMsg[19], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t21.txt=\"%x\"%c%c%c", mRxMsg[20], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t22.txt=\"%x\"%c%c%c", mRxMsg[21], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t23.txt=\"%x\"%c%c%c", mRxMsg[22], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t24.txt=\"%x\"%c%c%c", mRxMsg[23], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t25.txt=\"%x\"%c%c%c", mRxMsg[24], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t26.txt=\"%x\"%c%c%c", mRxMsg[25], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t27.txt=\"%x\"%c%c%c", mRxMsg[26], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t28.txt=\"%x\"%c%c%c", mRxMsg[27], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t30.txt=\"%x\"%c%c%c", mRxMsg[28], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t31.txt=\"%x\"%c%c%c", mRxMsg[29], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t32.txt=\"%x\"%c%c%c", mRxMsg[30], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t33.txt=\"%x\"%c%c%c", mRxMsg[31], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t34.txt=\"%x\"%c%c%c", mRxMsg[32], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t35.txt=\"%x\"%c%c%c", mRxMsg[33], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t36.txt=\"%x\"%c%c%c", mRxMsg[34], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t37.txt=\"%x\"%c%c%c", mRxMsg[35], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t38.txt=\"%x\"%c%c%c", mRxMsg[36], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t39.txt=\"%x\"%c%c%c", mRxMsg[37], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t40.txt=\"%x\"%c%c%c", mRxMsg[38], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy
        device.printf("t41.txt=\"%x\"%c%c%c", mRxMsg[39], 0xff, 0xff, 0xff);//affiche break sur bouton bt0 -------sy      
}    

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//******************************************************************LES TASKS**************************************************************//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////
//                TASKS1              //
////////////////////////////////////////

void task1_switch()
{ 

//lecture valeur codeur et conversion en radians
position_actuelle=qei.GetPosition();//lecture valeur codeur et affectation a la variable globale 
Tetam=pulsesToRadians(position_actuelle);//conversion valeur impulsionel en radians 

//Calcul de la nouvelle consigne:

//Etape1:derivee filtree 
dTetam=1./(1.+taud*2./dt_vit)*(-dTetam_n1*(1.-taud*2./dt_vit)+2./dt_vit*(Tetam-Tetam_n1));

//Etape2:calcul de integ non saturee
integ=integ_n1+dt_vit/2.*((Tetaco-Tetam)+(Tetaco_n1-Tetam_n1));

//Etape3:Calcul de A non saturee
A=Kv*K_sw/Umax*(-dTetam+Kp*Ki*integ-Kp*Tetam);

//Etape 4 et 5 : calcul de integ saturee
if (A>1)
    {
    integ=1./Kp/Ki*(Umax/Kv/K_sw+dTetam+Kp*Tetam);
    A=1;
    }
if(A<-1)
    {
    integ=1./Kp/Ki*(-Umax/Kv/K_sw+dTetam+Kp*Tetam); 
    A=-1; 
    }
    
//Etape 6:affectation du signe de rotation a l'etage de puissance 
if (A>0)
{
    signe_rot=1;
    sens_rotation_moteur1.write(signe_rot); //affectation du sens de rotation moteur1
    cyclic=A;
}
else 
{
    signe_rot=0;
    sens_rotation_moteur1.write(signe_rot); //affectation du sens de rotation moteur1
    cyclic=-A;//peut etre une erreur ici sy??
}

PWM1.write(cyclic);// affectation  de la valeur calculé en pwm

//   enregistrement des valeurs N-1
position_actuelle_n1=position_actuelle;   
dTetam_n1=dTetam;
Tetaco_n1=Tetaco;
Tetam_n1=Tetam;
integ_n1=integ;

//myled1=!myled1;//changement etat de la led1
}

////////////////////////////////////////
//                TASKS2              //
////////////////////////////////////////

void task2_switch()
{
//        pc.printf("%f\r\n", Tetaco);//valeur float consigne  en radians le renvoyé par usb
//        pc.printf("%i\r\n", position_actuelle);//valeur int du codeur renvoyé par usb        
//        pc.printf("%f\r\n", Tetam);//valeur float du codeur en radians renvoyé par usb
//        pc.printf("dTetam : %f\r\n", dTetam);//valeur float dTetam
//        pc.printf("integ : %f\r\n", integ);//valeur float integ               
//        pc.printf("%f\r\n", A);//valeur float du codeur en radians le renvoyé par usb
//        pc.printf("%e\r\n", cyclic);//valeur float du codeur en radians le renvoyé par usb
//        pc.printf("\r\n");//retour chario
//        pc.printf("$%d %d %d;", position_actuelle,position_actuelle/2,position_actuelle/10 ); //utiliser avec logicielle serial port ploter 
//        pc.printf("$%d ;", position_actuelle); //utiliser avec logicielle serial port ploter 
//       pc.printf("%d",position_actuelle); //utiliser avec logicielle serial port ploter 
 
// this code is a crude template
// you will need to edit this


// use this loop if sending integers----------------------------------------------SY

//    int ppp = position_actuelle;
//    char text[7];
//    snprintf(text, 7, "%d", ppp);
//    pc.printf("\r");
//    pc.printf(text);


// or use this loop if sending floats

//    float ppp =position_actuelle;
//    char ppp_text[30];
//    dtostrf(ppp, 10, 10, ppp_text);
//    char text[31];
//    snprintf(text, 31, "%s", ppp_text);
//    pc.printf(text);

//device.printf("add 1,0,%d%c%c%c", (position_actuelle/1000)+16500, 0xff, 0xff, 0xff);// pour la fonction waveform add id1,chanel0,position actu        
device.printf("add 1,0,%d%c%c%c", (position_actuelle/1000)+16500, 0xff, 0xff, 0xff);
};

////////////////////////////////////////
//                TASKS3              //
////////////////////////////////////////

void task3_switch()
{ 

//generation de la trajectoire 
if(start_slope)
{
    Teta_debut=Tetam;//affectation de la mesure a la variable globale
    Teta_fin=pulsesToRadians(consigne);//affectation de la consigne a la variable globale
    Teta_diff = Teta_fin - Teta_debut;//calcule de la position a parcourir
    delta_Teta=(Teta_diff/slope_time)*5*1e-4;//calcule de la distance ideal parcouru en 500us "regle de trois"!!!
    count_slope = 0;//mise a zero du conteur de pas 
    count_max = slope_time/(5*1e-4);//calcule du nombre max de pas 
    start_slope=false;
}
count_slope++;//incrementation nombre de pas
if (count_slope<=count_max){Tetaco=Tetaco+delta_Teta;}
 
}

////////////////////////////////////////
//                TASKS4              //
////////////////////////////////////////

void task4_switch()
{ 
//device.printf("$%d;", position_actuelle); //utiliser avec logicielle serial port ploter 
//pc.printf("0x%04x\n", valueFromMaster);
//pc.printf("%04x", valueFromMaster);

//device.printf("add 1,0,%d%c%c%c", (position_actuelle/500), 0xff, 0xff, 0xff);// pour la fonction waveform add id1,chanel0,position actu

//pc.printf("%1.3f \n\r",ADCdata);
pc.printf("add 1,0,%d%c%c%c", (position_actuelle/1000)+16000, 0xff, 0xff, 0xff);
//pc.printf("n4.val=%d %c%c%c", position_actuelle, 0xff, 0xff, 0xff);
 
}

//////////////////////////////////////////////////////////////////////////////
//                TASKS5  reception et transfert données sur SPI            //
//////////////////////////////////////////////////////////////////////////////

void task5_switch()
{
        //reply=0xAAAA;
        //spi1.reply(reply);  
        if (spi1.receive()) 
        {
            valueFromMaster = spi1.read();
            
            Spi_val_RX[x]=valueFromMaster;
            if (x==9){x=0;}
            else {x++;}
           
            // pc.printf("%d Something rxvd, and should have replied with %d\n\r", counter++, reply);
            //reply=valueFromMaster;
            //spi1.reply(reply);              // Prime SPI with next reply
            //reply--;
            
            //  pc.printf("    Received value from Master (%d) Next reply will be %d \r\n", valueFromMaster, reply);
            //if (reply==0){reply=65535;}//100
        }   

// ici code de la tache 5
}

/////////////////////////////////////////////////////////////////////////
//              TASKS6  lecture de l'image courant moteur              //
/////////////////////////////////////////////////////////////////////////
int z=0;
float result_conver_AD;

void task6_switch()
{  
    if (z!=9)
        {
            ADCdata=ADCdata+Ain; //sum 10 samples
            z++ ;
   
        } 

    if (z==9)
        {
            ADCdata=ADCdata/10; //divide by 10          
            z=0   ;
        }
    //device.printf("n0.val=%d%c%c%c", ADCdata, 0xff, 0xff, 0xff);// affiche la valeur de position  sur l afficheur nextion 
    //ADCdata=Ain.read_u16();
    
    if(ADCdata>=imax)//si l'image du courant egale a 0.5v je coupe le moteur .
        {
            c='d';//arret moteur 
            device.printf("g0.txt=\"over i\"%c%c%c", 0xff, 0xff, 0xff);//affiche
            //attendre que le manipulateur appuis sur le bouton restart a coder .
            //veriffier que les plaques sont bien en position .
            //faire une home ou continuer la trajectoire .a voir !!!!          
        }
// ici code de la tache 6
//-----------------------------------------------------------------attention manque le reset de la valeur ADCdata utilise if ......
}

////////////////////////////////////////
//                TASKS7              //
////////////////////////////////////////

//lecture d'un message valide pour traitement afficheur 

int ReadSerialMsg(char *Msg)
{
    if(device.readable())
    { 
        
        Msg[mRxIdx] = device.getc(); 
        mRxIdx++;
        if(mRxIdx > 3)
        {
            if ((Msg[mRxIdx-1] == 0xff) && (Msg[mRxIdx-2] == 0xff) && (Msg[mRxIdx-3] == 0xff)) //valid rx message
            { 
                mRxIdx=0;
                return 1;
            }
        }
    }
    return 0;
}

void FillButtonCmd(char *mRxMsg, ButtonCommand *cmd)
{
    cmd->IsNewCommandAvailable = 1;
    cmd->cmdNb = mRxMsg[0];
    cmd->var1 = mRxMsg[1];
    cmd->buttonId = mRxMsg[2];
    cmd->IsButtonPressed = mRxMsg[3]; 
}

void task7_switch()
{
    if(1 ==  ReadSerialMsg(mRxMsg))
    {
        Cmd = mRxMsg[0];
        //newCmdAvailable = true;
        
        switch(Cmd)
        {
            case PageCmd:
                //resetPageSteps();
                CurrentPageNb = (PageNb)mRxMsg[1];
            break;
            
            case ButtonCmd:
                FillButtonCmd(mRxMsg, &buttonCmd);
            break;        
        }
    }
    //lectureRSlcd();
    /*
    if(device.readable())
    {
       
        charac = device.getc(); 
        mRxMsg[mRxIdx] = charac;
        mRxIdx++;
        if ((mRxIdx >= 3) && (mRxMsg[mRxIdx-1] == 0xff) && (mRxMsg[mRxIdx-2] == 0xff) && (mRxMsg[mRxIdx-3] == 0xff)) //valid rx message
        { 
            myled3=1; 
            mRxIdx=0;
            myled3=0;
            if(mRxMsg[0] == 0x67) //Touch coordinate data return
            {
                mTouchX = (mRxMsg[1]*256) + mRxMsg[2];
                mTouchY = (mRxMsg[3]*256) + mRxMsg[4];
                if(mRxMsg[5] == 0x01)
                    mTouch = true; 
                else
                    mTouch = false;
             }    
        } 
           
//vitesse_actuelle=qei.GetVelocity();  //fonctionne pas ...  
// ici code de la tache 7
        myled1=0;
    }    */    
}

////////////////////////////////////////
//                TASKS8              //
////////////////////////////////////////
bool page_detect_ok;

void task8_switch()//detection code page
{
    if(page_detect_ok!=1)
    {
        if((mRxMsg[0] == 0x66)) 
        {  
            page_detect_ok!=1;
            switch ( mRxMsg[1]) 
            {
                case 0x00:
                page0();//ici la page0 es traité ----------- code de la page : 66 00 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;
        
                case 0x01:
                page1();//ici la page0 es traité ----------- code de la page : 66 01 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;
        
                case 0x02:
                page2();//ici la page0 es traité ----------- code de la page : 66 02 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;
        
                case 0x03:
                page3();//ici la page0 es traité ----------- code de la page : 66 03 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;
        
                case 0x04:
                page4();//ici la page0 es traité ----------- code de la page : 66 04 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;
        
                case 0x05:
                page5();//ici la page0 es traité ----------- code de la page : 66 05 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;

                case 0x06:
                page6();//ici la page6 es traité ----------- code de la page : 66 06 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                break;          

                case 0x07:
                page7();//ici la page7 es traité ----------- code de la page : 66 07 ff ff ff
                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                //memset(mRxMsg, 0, 5);
                break;      
                          
            }     
        }
    }
// ici code de la tache 8    
}

//fonction pour faire la home 
void do_the_Home()
{
 myled1=1;
 c='f'; //mouvement sortie du capteur 
}

void do_the_Home1()
{
 position_sortie_capteur_de_home=(LPC_QEI->QEIPOS);
 myled1=0;
 c='d';//arret moteur en 1ms
 position_home =position_initial-position_sortie_capteur_de_home;
 home_done_tag=1;
 device.printf("g0.txt=\"Home done\"%c%c%c", 0xff, 0xff, 0xff);//affiche
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                   PROGRAMME PRINCIPAL                                                                   //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int motorStep = 0;
int position_a_cmd_darret = 0;
                                                
int main()
{
                // int cycles;
                //NVIC_SetPriority(EINT3_IRQn, 252);//set interupt to highest priority 0.
                //NVIC_SetPriority(TIMER1_IRQn, 253);// set mbed tickers to lower priority than other things
                //NVIC_SetPriority(TIMER2_IRQn, 254);// set mbed tickers to lower priority than other things
                //NVIC_SetPriority(TIMER3_IRQn, 255);// set mbed tickers to lower priority than other things
                //NVIC_set_all_irq_priorities(0);
                
                qei.SetDigiFilter(480UL);//filtre 
                qei.SetMaxPosition(0xFFFFFFFF);//position max 4294967295 pulses
                
//initialisation de la com rs232                
                device.baud(9600);//rs232 28800 baud    
                //device.printf("serial rs232 ok \n");
                
                //calculs  de tau ,Kv,Kp          
                tau=(J*R)/K;
                Kv=r1*r2*tau*Ki-1.;
                if(Kv<0){Kv = -Kv;}
                Kp=r1*Ki*(1.+Kv)/Kv;
                              
//initialisation moteur   
PWM1.period(0.00005);// initialisation du rapport cyclique fixe la période à 50us----f=20Khz
frein_moteur1.write(0);//affectation de la valeur du frein moteur1
sens_rotation_moteur1.write(0); //affectation du sens de rotation moteur1 non utiliser puisque c'est la tache1 qui le fait non pas la generation de trajectoire

//initialisation du spi
    spi1.format(16,3);        // Setup:  bit data, high steady state clock, 2nd edge capture
    spi1.frequency(1000000); // 1MHz
    
//lancement des tasks               
                time_up1.attach(&task1_switch, 0.0005);//"calcule de l'asservissement" initialisation du ticker a 2Khz "500us".
                time_up2.attach(&task2_switch, 0.034);//"retour d'information position.
                time_up3.attach(&task3_switch, 0.0005);//"generation trajectoire" initialisation du ticker a 2khz "500us".
                time_up4.attach(&task4_switch, 0.034);//"retour d'information position par rs232"initialisation du ticker a 100hz "10ms".
                //time_up5.attach(&task5_switch, 0.0001);//"lecture et ecriture DATA SPI1 initialisation du ticker 10khz.
                
                time_up6.attach(&task6_switch, 0.034);//retour d'information courant.
                time_up7.attach(&task7_switch, 0.00005);//lecture de la com rs tous les 100us.
               // time_up8.attach(&task8_switch, 0.5);//detection numero de page tous les 100 ms.

input1.fall(&do_the_Home);//declaration d une interuption lié a input1 pour faire la home 
input1.rise(&do_the_Home1);//declaration d une interuption lié a input1 pour faire la home  

device.printf("sendme");
count_ticks=0; 
c='0';

home_done_tag=0;
device.printf("g0.txt=\"home?? \"%c%c%c", 0xff, 0xff, 0xff);//affiche 
wait(2);                
        while(1)
        {
            myled1 = 0;

            if(buttonCmd.IsNewCommandAvailable == 1)//si y as eu un bouton appuyé et que nous somme bien en la page n°7
                       
            {
                motorStep = 0;
             
                switch(buttonCmd.cmdNb)
                {
                    case PageCmd:
                        switch ( buttonCmd.var1) 
                        {
                            case 0x00:
                                page0();//ici la page0 es traité ----------- code de la page : 66 00 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;
                            
                            case 0x01:
                                page1();//ici la page0 es traité ----------- code de la page : 66 01 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;
                            
                            case 0x02:
                                page2();//ici la page0 es traité ----------- code de la page : 66 02 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;
                            
                            case 0x03:
                                page3();//ici la page0 es traité ----------- code de la page : 66 03 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;
                            
                            case 0x04:
                                page4();//ici la page0 es traité ----------- code de la page : 66 04 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;
                            
                            case 0x05:
                                page5();//ici la page0 es traité ----------- code de la page : 66 05 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;
                    
                            case 0x06:
                                page6();//ici la page6 es traité ----------- code de la page : 66 06 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                            break;          
                    
                            case 0x07:
                                page7();//ici la page7 es traité ----------- code de la page : 66 07 ff ff ff
                                mRxMsg[0] = 0x00;mRxMsg[1] = 0x00;mRxMsg[2] = 0x00;mRxMsg[3] = 0x00;mRxMsg[4] = 0x00;
                                //memset(mRxMsg, 0, 5);
                            break;      
                                          
                        }     
                    break;
                }                       
            }
 
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page0    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x00))//si y as eu un bouton appuyé et que nous somme bien en la page n°0
            {                            
               motorStep = 0;
               
                switch(buttonCmd.buttonId)
                {
                    case 0x02: // boutn 'A' de la page 0
                       
                        c='a';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 0x01: // boutn 'B' de la page 0
                     
                        c='b';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                        

                    case 0x03: // boutn 'R' de la page 0
                     
                        c='c';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 0x04: // boutn 'L' de la page 0
                     
                        c='d';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                        

                    case 0x05: // boutn 'R2' de la page 0
                        
                        c='d';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 32: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;
                                                
                    case 7: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                              
                  
                    case 13: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                              
                        
                    case 14: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                              
                        
                    case 15: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;
                        
                    case 35: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;
                        
                    case 11: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 8: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;
                        
                    case 10: // boutn 'R2' de la page 0
                        
                        page_detect_ok=0 ;
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;
                                                                                                                                                                                                                             
                }                         
            }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page1    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x01))//si y as eu un bouton appuyé et que nous somme bien en la page n°1
            { 
                //page1();
            }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page2    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x02))//si y as eu un bouton appuyé et que nous somme bien en la page n°2
            { 
                //page2();
            }        

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page3    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x03))//si y as eu un bouton appuyé et que nous somme bien en la page n°3
            { 
                //page3();
            }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page4    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x04))//si y as eu un bouton appuyé et que nous somme bien en la page n°4
            { 
                //page4();
            }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page5    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x05))//si y as eu un bouton appuyé et que nous somme bien en la page n°5
            { 
                 motorStep = 0;
                   
                switch(buttonCmd.buttonId)
                {
                    case 0x04: // boutn 'A' de la page 7
                   
                        c='a';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 0x05: // boutn 'B' de la page 7
                 
                        c='b';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                        

                    case 0x06: // boutn 'C' de la page 7
                      
                        c='c';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 0x07: // boutn 'D' de la page 7
                     
                        c='d';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;
                        
                    case 14: // boutn 'BTO' de la page 7  bouton mouvement home 
                   
                        c='h';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                             
                                                                        
                }                  
            }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page6    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x06))//si y as eu un bouton appuyé et que nous somme bien en la page n°6
            { 
                //page6();
            }
           
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////    page7    ////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if((buttonCmd.IsNewCommandAvailable == 1)&&(mRxMsg[1]==0x07))//si y as eu un bouton appuyé et que nous somme bien en la page n°7
            {               
                motorStep = 0;
                                       
                switch(buttonCmd.buttonId)
                {
                    case 0x2f: // boutn 'A' de la page 7
                     
                        c='a';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 0x30: // boutn 'B' de la page 7
                   
                        c='b';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                        

                    case 0x31: // boutn 'C' de la page 7
                   
                        c='c';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;

                    case 0x32: // boutn 'D' de la page 7
                    
                        c='d';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break;                        

                    case 0x01: // boutn 'D' de la page 7
                    
                        c='d';
                        buttonCmd.IsNewCommandAvailable = 0;          
                        break; 
                                                                        
                }           
             }    
                //c=valueFromMaster;//valeur par la liaison spi par le master
                //device.scanf("%c",&c);//capture du caract ascii 

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////   differants mouvement    ///////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


              (LPC_QEI->QEIPOS)=0;        
                switch(c)//commande moteur                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
                {
                    case 'a':
                        if(home_done_tag==1)
                        { 
                        //qei.Reset(0);
                            switch(motorStep)
                            {
                                case 0:
                                    consigne=70000-position_home ;                                
                                    slope_time=0.25;//t =s
                                    start_slope=true;
                                    {
                                        motorStep = 1;
                                    }
                                break;
                            
                                case 1:
                                    if(true == Wait2(0, 550))//ms
                                    {
                                        motorStep = 2;                                    
                                    }
                                break;
                           
                                case 2:
                                    consigne=132000-position_home ;                                 
                                    slope_time=2.5;//s
                                    start_slope=true;
                                    {
                                        motorStep = 3;
                                    }
                                break;
                            
                                case 3:
                                    if(true == Wait2(0, 3000))//ms
                                    {
                                        motorStep = 4;
                                    }
                                    break;
                            
                                case 4:
                                    consigne=35000-position_home ;                                 
                                    slope_time=2.5;//s
                                    start_slope=true;
                                    {
                                        motorStep = 5;
                                    }
                                break;
    
                                case 5:
                                    if(true == Wait2(0, 3000))//ms
                                    {
                                        motorStep = 6;
                                    }
                                break;
                            
                                case 6:
                                    consigne=0-position_home ;                                
                                    slope_time=2.5;//s
                                    start_slope=true;
                                    {
                                        motorStep = 7;
                                    }
                                break;
                            
                                case 7:
                                    if(true == Wait2(0, 3000))//ms
                                    {
                                        motorStep = 0;
                                    }
                                break;
                            }    
                        }
                    break;  

                    case 'b':
                        if(home_done_tag==1)
                        {                     
                        //qei.Reset(0);
                            switch(motorStep)
                            {
                                case 0:
                                    consigne=0-position_home ;  //1 tour                               
                                    slope_time=3;//s
                                    start_slope=true;
                                    {
                                        motorStep = 1;
                                    }
                                    break;
                                
                                case 1:
                                    if(true == Wait2(0, 3500))//ms
                                    {
                                        motorStep = 2;                                    
                                    }
                                    break;
                               
                                case 2:
                                    consigne=10000-position_home ;                               
                                    slope_time=0.25;//t=s
                                    start_slope=true;
                                    {
                                        motorStep = 3;
                                    }
                                    break;
                                
                                case 3:
                                    if(true == Wait2(0, 400))//ms
                                    {
                                        motorStep = 4;
                                    }
                                    break;
                                
                                case 4:
                                    consigne=20000-position_home ;                                
                                    slope_time=0.25;//t=s
                                    start_slope=true;
                                    {
                                        motorStep = 5;
                                    }
                                    break;
        
                                case 5:
                                    if(true == Wait2(0, 400))//ms
                                    {
                                        motorStep = 6;
                                    }
                                    break;
                                    
                                case 6:
                                    consigne=30000-position_home ;                              
                                    slope_time=0.25;//t=s
                                    start_slope=true;
                                    {
                                        motorStep = 7;
                                    }
                                    break;
                                    
                                case 7:
                                    if(true == Wait2(0, 400))//ms
                                    {
                                        motorStep = 8;
                                    }
                                    break;
                                    
                                case 8:
                                    consigne=40000-position_home ;                                 
                                    slope_time=0.25;//t=s
                                    start_slope=true;
                                    {
                                        motorStep = 9;
                                    }
                                    break;
                                    
                                case 9:
                                    if(true == Wait2(0, 400))//ms
                                    {
                                        motorStep = 10;
                                    }
                                    break; 
                                                                   
                                case 10:
                                    consigne=50000-position_home ;                                 
                                    slope_time=0.25;//t=s
                                    start_slope=true;
                                    {
                                        motorStep = 11;
                                    }
                                    break;
                                    
                                case 11:
                                    if(true == Wait2(0, 400))//ms
                                    {
                                        motorStep = 12;
                                    }
                                    break;
                                                                                                    
                                case 12:
                                    consigne=60000-position_home ;                                 
                                    slope_time=0.25;//t=s
                                    start_slope=true;
                                    {
                                        motorStep = 13;
                                    }
                                    break;
                                    
                                case 13:
                                    if(true == Wait2(0, 400))//ms
                                    {
                                        motorStep = 14;
                                    }
                                    break;
                                                                                                    
                                case 14:
                                    consigne=132000-position_home ;                                 
                                    slope_time=1;//t=s
                                    start_slope=true;                                                                  
                                    {   
                                        motorStep = 15;
                                    }
                                    break;
                                    
                                case 15:
                                    if(true == Wait2(0, 1200))//ms
                                    {                                   
                                        motorStep = 0;
                                    }
                                    break;
                            }                                                                                                
                        }
                        break;  
                        
                    case 'c':
                        if(home_done_tag==1)
                        { 
                        //qei.Reset(0);
                            switch(motorStep)
                            {
                                case 0:
                                    consigne=132000-position_home ;  //1 tour                               
                                    slope_time=2.5;//t =s
                                    start_slope=true;
                                    {
                                        motorStep = 1;
                                    }
                                    break;
                                
                                case 1:
                                    if(true == Wait2(0, 3000))//ms
                                    {
                                        motorStep = 2;                                    
                                    }
                                    break;
                               
                               case 2:
                                    consigne=0-position_home ;  //1 tour                               
                                    slope_time=2.5;//t=ms
                                    start_slope=true;
                                    {
                                        motorStep = 3;
                                    }
                                    break;
                                
                                case 3:
                                    if(true == Wait2(0, 3000))//ms
                                    {
                                        motorStep = 0;
                                    }
                                    break;
                            }               
                        }
                        break;  

                    case 'd'://arret a la position actuelle 
                        count_slope = 0;
                        position_a_cmd_darret=(LPC_QEI->QEIPOS);//sauvegarde position d'arret 
                        consigne=position_a_cmd_darret ;  //arret a la position                                
                        slope_time=0.010;//t =10ms
                        start_slope=true;
                        Wait2(0, 10);
                        
                        //qei.Reset(QEI_RESET_POS);
                        //qei.Reset(QEI_RESET_POSOnIDX);
                        //qei.Reset(QEI_RESET_VEL);
                        //qei.Reset(QEI_RESET_IDX);
                                                                                   
                    break;

                    case 'e'://allez a la position0 apret rising edge capteur de home 
                       
                        
                        consigne=((LPC_QEI->QEIPOS)+1000) ;  //arret a la position0 +1000                               
                        slope_time=10;//t =10s
                        start_slope=true;
                        //Wait2(0, 5000);
                        
                        //qei.Reset(QEI_RESET_POS);
                        //qei.Reset(QEI_RESET_POSOnIDX);
                        //qei.Reset(QEI_RESET_VEL);
                        //qei.Reset(QEI_RESET_IDX);
                                                                                   
                    break;                     

                    case 'f'://sortie du capteur home 
                       
                       
                        consigne=(LPC_QEI->QEIPOS)+125000 ;                                 
                        slope_time=15;//t =2000ms
                        start_slope=true;
                       // Wait2(0, 10000);
                        
                        //qei.Reset(QEI_RESET_POS);
                        //qei.Reset(QEI_RESET_POSOnIDX);
                        //qei.Reset(QEI_RESET_VEL);
                        //qei.Reset(QEI_RESET_IDX);
                                                                                   
                    break; 

                    case 'g'://arret a la position actuelle 
                       
                        position_a_cmd_darret=(LPC_QEI->QEIPOS);//sauvegarde position d'arret 
                        consigne=position_a_cmd_darret ;  //arret a la position                                
                        slope_time=0.25;//t =2000ms
                        start_slope=true;
                        Wait2(0, 500);
                        
                        //qei.Reset(QEI_RESET_POS);
                        //qei.Reset(QEI_RESET_POSOnIDX);
                        //qei.Reset(QEI_RESET_VEL);
                        //qei.Reset(QEI_RESET_IDX);
                                                                                   
                    break; 

                    case 'h'://mouvement de la home apret un arret 
                        switch(motorStep)
                        {
                            case 0:
                            //count_slope = 0;
                            position_a_cmd_darret=(LPC_QEI->QEIPOS);//sauvegarde position d'arret 
                            consigne=position_a_cmd_darret ;  //arret a la position                                
                            slope_time=0.1;//t =10ms
                            start_slope=true;
                            Wait2(0, 100);//ms
                                {
                                    motorStep = 1;
                                }
                                break;
                            
                            case 1:
                                if(true == Wait2(0, 10))//ms
                                {
                                    motorStep = 2;                                
                                }
                                break;                            

                            case 2:
                            count_slope = 0;
                             
                            consigne=-1125000 ;  //arret a la position                                
                            slope_time=60;//t =40s
                            start_slope=true;


                                break;
                            
                                
                        }
                                                                                   
                    break; 
                                                      
                } 
            
        
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/*if(device2.readable())//ici on utilise une seconde com rs avec un autre ecrant nextion 
    { 
        c2 = device2.getc(); 
        mRxMsg2[mRxIdx2] = c2;
        mRxIdx2++;
        if ((mRxIdx2 >= 3) && (mRxMsg2[mRxIdx2-1] == 0xff) && (mRxMsg2[mRxIdx2-2] == 0xff) && (mRxMsg2[mRxIdx2-3] == 0xff)) //valid rx message
        { 
          mRxIdx2=0;
        
            if(mRxMsg2[0] == 0x67) //Touch coordinate data return
             {   mTouchX2 = (mRxMsg2[1]*256) + mRxMsg2[2];
                mTouchY2 = (mRxMsg2[3]*256) + mRxMsg2[4];
                if(mRxMsg2[5] == 0x01)
                    mTouch2 = true; 
                else
                    mTouch2 = false;
             }
             //start switch
            if((mRxMsg2[0] == 0x65)&&(mRxMsg2[1] == 0x01)&&(mRxMsg2[2] == 0x01)&&(mRxMsg2[3] == 0x00))
             {
              keyboard.printf("t");
             }//uniquement le bouton start allumeras la led 1 en release ---------------SY

        }
    }*/   
    
//wait(0.05);    
        }
}