#include "NextionLCD.h"
#include "mbed.h"


/* ***************************************** Public Functions ***************************************** */

NextionLCD::NextionLCD(PinName Tx, PinName Rx) : lcd(Tx, Rx) {
    lcd.baud(9600);
    mTouch=false;
    mRxIdx=0;
    lcd.printf("rest%c%c%c", 0xff, 0xff, 0xff);
    lcd.printf("rest%c%c%c", 0xff, 0xff, 0xff);
    wait(1.0);
    lcd.printf("sendxy=1%c%c%c", 0xff, 0xff, 0xff);
    lcd.attach(this,&NextionLCD::RxInterrupt,Serial::RxIrq);
}

void NextionLCD::ClrScr(uint16_t color) {
    lcd.printf("cls %d%c%c%c", color, 0xff, 0xff, 0xff);
}

void NextionLCD::DrawString(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint8_t font, uint16_t fontcolor, uint16_t backcolor, uint8_t xcenter, uint8_t ycenter, char *str) {
    lcd.printf("xstr %d,%d,%d,%d,%d,%d,%d,%d,%d,1,\"%s\"%c%c%c", x, y, w, h, font, fontcolor, backcolor, xcenter, ycenter, str,0xff, 0xff, 0xff);
}

void NextionLCD::DrawPixel(uint16_t x, uint16_t y, uint16_t color) {
    lcd.printf("fill %d,%d,1,1,%d%c%c%c", x, y, color, 0xff, 0xff, 0xff);
}

void NextionLCD::DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color) {
    lcd.printf("line %d,%d,%d,%d,%d%c%c%c", x1, y1, x2, y2, color, 0xff, 0xff, 0xff);
}

void NextionLCD::DrawRectangle(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t color) {
    lcd.printf("draw %d,%d,%d,%d,%d%c%c%c", x, y, x+w, y+h, color, 0xff, 0xff, 0xff);
}

void NextionLCD::FillRectangle(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t color) {
    lcd.printf("fill %d,%d,%d,%d,%d%c%c%c", x, y, w, h, color, 0xff, 0xff, 0xff);
}

void NextionLCD::DrawCircle(uint16_t x, uint16_t y, uint16_t r, uint16_t color) {
    lcd.printf("cir %d,%d,%d,%d%c%c%c", x, y, r, color, 0xff, 0xff, 0xff);
}

void NextionLCD::FillCircle(uint16_t x, uint16_t y, uint16_t r, uint16_t color) {
    lcd.printf("cirs %d,%d,%d,%d%c%c%c", x, y, r, color, 0xff, 0xff, 0xff);
}

bool NextionLCD::Touch(void) {
    return mTouch;
}

int NextionLCD::TouchX(void) {
    return mTouchX;
}

int NextionLCD::TouchY(void) {
    return mTouchY;
}



/* ***************************************** Private Functions ***************************************** */




/************************* Private Callback Functions *************************/
void NextionLCD::RxInterrupt(void) {
    char c;

    if(lcd.readable()) {
        c = lcd.getc(); 
        mRxMsg[mRxIdx] = c;
        mRxIdx++;
        if ((mRxIdx >= 3) && (mRxMsg[mRxIdx-1] == 0xff) && (mRxMsg[mRxIdx-2] == 0xff) && (mRxMsg[mRxIdx-3] == 0xff)) {  //valid rx message
            mRxIdx=0;
            if(mRxMsg[0] == 0x67) {         //Touch coordinate data return
                mTouchX = (mRxMsg[1]*256) + mRxMsg[2];
                mTouchY = (mRxMsg[3]*256) + mRxMsg[4];
                if(mRxMsg[5] == 0x01)
                    mTouch = true;
                else
                    mTouch = false;
            }
        }
    }
}