#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0);// Pin must be on ports A or D
InterruptIn button1(PTD5);  
DigitalOut led(LED_BLUE);
DigitalOut led1(LED_RED);

volatile int pressEvent = 0 ;
volatile int pressEvent1 = 0 ;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = !pressEvent;  
}
void buttonCallback1(){
    pressEvent1 = !pressEvent1 ;  
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    button1.mode(PullUp);             // Ensure button i/p has pull up
    button1.fall(&buttonCallback1) ;   // Attach function to falling edge
    
    while(true) {
        // Toggle the LED every time the button is pressed
        if (pressEvent) { 
            led = !led ;
        }
         if (pressEvent1) {
            led1 = !led1 ;
        }
        ThisThread::sleep_for(500) ; // delay for 100ms 
    }
}