#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
TSISensor tsi;


Thread redThread ; // thread for red LED
Thread greenThread ; // thread for green LED
Thread blueThread;
Thread whiteThread;



# define FLAG1 0x01   
# define FLAG2 0x02
# define FLAG3 0x04   
# define FLAG4 0x08
EventFlags signals;  // event flags for signalling; 4 used
 
void red_thread()    // method to run in thread
{
redLED = true ; // turn off 
greenLED = true ; // turn off 
blueLED = true;
    enum state {ON, OFF} lev ;
    lev = OFF;
    while (true) {
        switch (lev) {
            case ON:
                signals.wait_any(FLAG1);
                redLED = true ; // turn off
                //signals.clear(FLAG1) ;
                lev= OFF;
                break ;
            case OFF:
                signals.wait_any(FLAG1);
                redLED = false ; // turn off
                lev = ON;
                break ;
                //signals.clear(FLAG1) ;
                // Signal are automatically cleared by wait_any but
        }   // the signal might have been set again while LED on
    }
}

void green_thread()    // method to run in thread
{
    redLED = true ; // turn off
    greenLED = true ; // turn off
    blueLED = true;
    enum state {ON, OFF} lev ;
    lev = OFF;
    while (true) {
        switch (lev) {
            case ON:
                signals.wait_any(FLAG2);
                greenLED = true ; // turn off
                lev = OFF;
                break ;
            //signals.clear(FLAG2) ;
            case OFF:
                signals.wait_any(FLAG2);
                greenLED = false ; // turn off
                lev = ON;
                break ;
                
                //signals.clear(FLAG2) ;
                // Signal are automatically cleared by wait_any but
                // the signal might have been set again while LED on
        }
    }
}
void blue_thread()    // method to run in thread
{
redLED = true ; // turn off 
greenLED = true ; // turn off 
blueLED = true;
    enum state {ON, OFF} lev ;
    lev = OFF;
    while (true) {
        switch (lev) {
            case ON:
                signals.wait_any(FLAG3);
                blueLED = true ; // turn off
                lev = OFF ;
                break ;
            //signals.clear(FLAG3) ;
            case OFF:
                signals.wait_any(FLAG3);
                blueLED = false ; // turn off
                lev = ON ;
                break ;
                //signals.clear(FLAG3) ;
                // Signal are automatically cleared by wait_any but
                // the signal might have been set again while LED on
        }
    }
}
void white_thread() {  // method to run in thread
redLED = true ; // turn off 
greenLED = true ; // turn off 
blueLED = true;
enum state {ON, OFF} lev ;
    lev = OFF;
    while (true) {
      switch (lev){
      case ON:
        signals.wait_any(FLAG4);
                break ;
                lev = OFF;
      case OFF:
        signals.wait_any(FLAG4);
                break ;
                lev = ON;
        //signals.clear(FLAG4) ;
          // Signal are automatically cleared by wait_any but
          // the signal might have been set again while LED on 
        }
    }
}

int main(void) {
    //redLED = true ; // turn off 
    //greenLED = true ; // turn off 
    //blueLED = true;
    
    redThread.start(red_thread) ; // start the red thread
    greenThread.start(green_thread) ; // start the green thread
    blueThread.start(blue_thread) ; // start the red thread
    whiteThread.start(white_thread) ; // start the green thread
    
    enum position { none, leftout, leftin, rightin, rightout,} pos;
    pos = none;
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d", d) ;  
        pc.putc(' ') ;
        switch (pos) {

            case none:
                if ((d > 3)&& (d<9))  {
                    pos = leftout;
                    signals.set(FLAG1);
                    pc.printf("Case Leftout \n\r", d);
                }
                if ((d > 13)&&(d<19))  {
                    pos = leftin;
                    signals.set(FLAG2);
                    pc.printf("Case Leftin \n\r", d);
                }
                if ((d > 23)&&(d <29))  {
                    pos = rightin;
                    signals.set(FLAG3);
                    pc.printf("Case Rightin \n\r", d);
                }
                if (d > 33) {
                    pos = rightout;
                    signals.set(FLAG4);
                    pc.printf("Case Rightiout \n\r", d);
                }
                break;

            case leftout:
                if ((d < 3)||(d>9))  {
                    pos = none;
                    pc.printf("Case None \n\r", d);
                }
                break;

            case leftin:
                if ((d < 13)||(d>19))  {
                    pos = none;
                    pc.printf("Case None \n\r", d);
                }
                break;

            case rightin:
                if ((d < 23)||(d>29))  {
                    pos = none;
                    pc.printf("Case None \n\r", d);
                }
                break;
            case rightout:
                if (d < 33)  {
                    pos = none;
                    pc.printf("Case None \n\r", d);
                }
                break;
        }

        //if (d == 10) signals.set(REDFLAG) ;
        //if (d == 20) signals.set(GREENFLAG) ;
        ThisThread::sleep_for(500) ; // This polling rate is too slow - increase it
        // The slower rate maks it easier to output on the terminal
    }
}