// Lab 3 Example Program 2
// -----------------------
// Periodically write to the AnalogOut to create a sine wave
// Alternate between two fixed frequencies every 5 sec
// 
// This code uses the Ticker API to create a periodic interrupt
// Devices used in this way must not call locks; a variant of 
//   the AnalogOut device w/o locking is created for this.
//
// Updated for mbed 5

// THIS VERSION HAS NO DEBUGGING CODE

#include "mbed.h"
#include "sineTable.h"

// --------------------------
// This declaration introduces a derived version of the mbed AnalogOut
//   class with the locking removed.
// You do NOT NEED TO UNDERSTAND this 
class AnalogOut_unsafe : public AnalogOut {
  public:
    AnalogOut_unsafe (PinName pin) : AnalogOut (pin) {} 
  protected: 
    virtual void lock() {}
    virtual void unlock() {}
};
// --------------------------
AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(D3);   // Red LED
DigitalOut led2(D4);
DigitalOut led3(D5);
DigitalOut led4(D6);
DigitalOut led5(D7);
InterruptIn b1(PTD0);
Ticker tick ;          // Creates periodic interrupt
AnalogOut_unsafe ao(PTE30) ;  // Analog output
EventQueue queue;  // creates an event queue, to call read ADC

volatile int pressEvent = 1 ;
volatile int index = 0 ; 

Serial pc(USBTX, USBRX); // tx, rx, for debugging

Thread eventThread ;

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Average using a low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}
void buttonCallback(){
    pressEvent = 1 ;  
}
    int volts = 0 ;
    int max = 330; 
// Function called periodically
// Write new value to AnalogOut 

void writeAout() {
    ao.write_u16(sine[index]) ;
    index = (index + 1) % 64 ;   
}
 
// Control the frequency of updates
//   Alternative between two frequencies      
int main() {
     b1.mode(PullUp);
    b1.fall(&buttonCallback);
    int update_us = 1000 ; // 1ms
    led1 = 0; // turn off 
    led2 = 0;// turn off 
    led3 = 0;// turn off 
    led4 = 0;// turn off 
    led5 = 0;  // turn off 
    int volts = 0 ;
    int max = 0 ;
    const int threshold = 100 ;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;
  
    
    // Start the event queue
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));

    // call the readA0 function every 10ms 
    queue.call_every(10, readA0) ; 

    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
             if (pressEvent) {
                 pressEvent = 0;
            max = (mess->analog * 330) / 0xffff ;
        }
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
            //if (volts > threshold) led1 = 0 ; else led1 = 1 ;
            if (volts > 0 && volts < max/6) {
                led1 = 0;
                led2 = 0;
                led3 = 0;
                led4 = 0;
                led5 = 0; 
                }
            if (volts > max/6 && volts < 2*max/6) {
                led1 = 1;
                led2 = 0;
                led3 = 0;
                led4 = 0;
                led5 = 0; 
                }
             if (volts > 2*max/6 && volts < 3*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 0;
                led4 = 0;
                led5 = 0; 
                }
             if (volts > 3*max/6 && volts < 4*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 1;
                led4 = 0;
                led5 = 0; 
                }
            if (volts > 4*max/6 && volts < 5*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 1;
                led4 = 1;
                led5 = 0; 
                }
            if (volts > 5*max/6 && volts < 6*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 1;
                led4 = 1;
                led5 = 1; 
                }
            
       
    
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        //ThisThread::sleep_for(30000) ; // wait 30 sec 
       // int f = 1 + (49 * volts / 330);
        //int t = 1 / (f * 64) ;
        update_us = volts*100/64; // 2ms
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        //ThisThread::sleep_for(30000) ; // wait 30 sec 
        update_us = 1000 ; // 1ms
                
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }
    }
}

