#include "mbed.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    enum position { flat, over, intermediate, down, up, left, right } pos;
    pos = intermediate;
    //orientationstate cases = flat;
 
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
  
        switch (pos) {

            case flat:
               if (z < 0.8)  {
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }
        
            break;

        case over:
                if (z > -0.8) {
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }
        break;

        case intermediate:
                if (z < -0.9 ) {
                    rled = 1;
                    gled = 0;
                    bled = 1;
                    pos = over;
                    pc.printf("Board Orientation : Over\n\r");
                    }
    
                 if ((z > 0.9 ) ){
                    rled = 1;
                    gled = 0;
                    bled = 1;
                    pc.printf("Board Orientation : Flat\n\r");
                    pos = flat;
                 }
                /*if ((z < 0.8) && (z > -0.8)&& (x < 0.8) && (x > -0.8) && (z < 0.8) && (z > -0.8)) {
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }*/
                if ((x  >0.9) ) {
                    rled = 1;
                    gled = 1;
                    bled = 0;
                    pos = down;
                    pc.printf("Board Orientation : Down\n\r");
                }
                if (x < -0.9) {
                    rled = 1;
                    gled = 1;
                    bled = 0;
                    pos = up;
                    pc.printf("Board Orientation : Up\n\r");
                  
                }
                if ((y > 0.9 ) ) {
                    rled = 0;
                    gled = 1;
                    bled = 1;
                    pos = left;
                    pc.printf("Board Orientation : Left\n\r");
                  
                }
                if (y < -0.9) {
                    rled = 0;
                    gled = 1;
                    bled = 1;
                    pos = right;
                    pc.printf("Board Orientation : Right\n\r");
                   
                }
                
            break;
            
        case down:
                if (x < 0.8) {
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }
        break;

        case up:
                if (x > - 0.8)  {
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }
               
            break;

        case left:
                
                if (y < 0.8 ){
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }
                
        break;

        case right:

                if (y > - 0.8)  {
                    rled = 1;
                    gled = 1;
                    bled = 1;
                    pos = intermediate;
                }
           
        break;
        //rled = 1.0f - abs(x);
        //gled = 1.0f - abs(y);
        //bled = 1.0f - abs(z);
        ThisThread::sleep_for(3000);  // wait(0.3);

        }
    }
    }