
// LAB 3 SAMPLE PROGRAM 1


#include "mbed.h"


AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(D3);   // Red LED
DigitalOut led2(D4);
DigitalOut led3(D5);
DigitalOut led4(D6);
DigitalOut led5(D7);
InterruptIn b1(PTD0);


EventQueue queue;  // creates an event queue, to call read ADC

Serial pc(USBTX, USBRX); // tx, rx, for debugging

volatile int pressEvent = 1 ;
void buttonCallback(){
    pressEvent = 1 ;  
}

// This thread runs the event queue
Thread eventThread ;

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Average using a low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
    led1 = 0; // turn off 
    led2 = 0;// turn off 
    led3 = 0;// turn off 
    led4 = 0;// turn off 
    led5 = 0;  // turn off 
    int volts = 0 ;
    int max = 0 ;
    const int threshold = 100 ;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;
    b1.mode(PullUp);
    b1.fall(&buttonCallback);
    
    // Start the event queue
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));

    // call the readA0 function every 10ms 
    queue.call_every(10, readA0) ; 

    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
             if (pressEvent) {
                 pressEvent = 0;
            max = (mess->analog * 330) / 0xffff ;
        }
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
            //if (volts > threshold) led1 = 0 ; else led1 = 1 ;
            if (volts > 0 && volts < max/6) {
                led1 = 0;
                led2 = 0;
                led3 = 0;
                led4 = 0;
                led5 = 0; 
                }
            if (volts > max/6 && volts < 2*max/6) {
                led1 = 1;
                led2 = 0;
                led3 = 0;
                led4 = 0;
                led5 = 0; 
                }
             if (volts > 2*max/6 && volts < 3*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 0;
                led4 = 0;
                led5 = 0; 
                }
             if (volts > 3*max/6 && volts < 4*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 1;
                led4 = 0;
                led5 = 0; 
                }
            if (volts > 4*max/6 && volts < 5*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 1;
                led4 = 1;
                led5 = 0; 
                }
            if (volts > 5*max/6 && volts < 6*max/6) {
                led1 = 1;
                led2 = 1;
                led3 = 1;
                led4 = 1;
                led5 = 1; 
                }
                
                
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }
    }
}
