#include "mbed.h"

//Setup a new class for a Shiftbrite RGB LED module
class Shiftbrite
{
public:
    Shiftbrite(PinName pin_e, PinName pin_l, PinName pin_do, PinName pin_di, PinName pin_clk);
    void write(int red, int green, int blue);

private:
//class sets up the pins
    DigitalOut _pin_e;
    DigitalOut _pin_l;
    SPI _spi;
};

Shiftbrite::Shiftbrite(PinName pin_e, PinName pin_l, PinName pin_do, PinName pin_di, PinName pin_clk)
    : _pin_e(pin_e), _pin_l(pin_l), _spi(pin_do, pin_di, pin_clk)
{
_pin_e=0;
_pin_l=0;
}

void Shiftbrite::write(int red, int green, int blue)
{
long colors=0;
long c=00;

red=red*4;
green=green*4;
blue=blue*4;

if(red>1023){
    red=1023;
    }
if(green>1023){
    green=1023;
    }
if(blue>1023){
    blue=1023;
    }
colors=(colors<<2)|(c&3);
colors=(colors<<10)|(blue&1023);
colors=(colors<<10)|(red&1023);
colors=(colors<<10)|(green&1023);

long s1=0xFF000000;
long s2=0xFF0000;
long s3=0xFF00;
long s4=0xFF;

_spi.write((s1&colors)>>24);
_spi.write((s2&colors)>>16);
_spi.write((s3&colors)>>8);
_spi.write(s4&colors);
_pin_l=1;
_pin_l=0;
}
