#include "mbed.h"
#include <mpr121.h>
#include <string>
#include "Shiftbrite.h"
#include "Servo.h"
#include "Motor.h"

//Print output to pc via usb
RawSerial  pc(USBTX, USBRX);
//Print output to Bluetooth device
RawSerial  dev(p13,p14);
Serial esp(p9, p10); // tx, rx
//LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Motor doorPulley(p22, p5, p6); // pwm, fwd, rev
Motor mailFeed(p21, p11, p12); // pwm, fwd, rev
Servo lock(p24);
AnalogIn   ds(p16);
//Interrupt for Touchpad
InterruptIn interrupt(p26);
//I2C for Touchpad 
I2C i2c(p28, p27);
//Touchpad 
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
//Shiftbrite

//Code Combinations
int code1[] = {1,1,1,1};
int code2[] = {2,2,2,2};
int code3[] = {8,8,8,8};//Key 4 (labeled 3) on touchpad

volatile int input[4]; //stores input values
volatile int inNdx = 0;//to place combination in input
bool codeIn = false; //determine if code is being entered via bluetooth

//Webserver variables
char gotMail[10];
char audio1[255];

// things for sending/receiving data over serial
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 4095;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();
int DataRX;
int update;
int count;
char cmdbuff[1024];
char replybuff[4096];
char webdata[4096]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
char timebuf[30];
void SendCMD(),getreply(),ReadWebData(),startserver();
void gettime(),setRTC(), getDS();
char rx_line[1024];
int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.
struct tm t;
float DSin = 0.0;
// manual set RTC values
int minute      =00;    // 0-59
int hour        =12;    // 2-23
int dayofmonth  =26;    // 1-31
int month       =8;     // 1-12
int year        =15;    // last 2 digits


//Interrupt method to read from touchpad
void fallInterrupt() {
       int key_code=0;
       int i = 0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    //output value to onboard LEDs
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
    //ignore second character and input value into inputNdx
    if (value > 0){
    input[inNdx] = value;
    inNdx++;  
    }

  
    
}

//receive value from bluetooth device
void dev_recv()
{
    string temp ="";
    led1 = !led1;
    while(dev.readable()) {
        //pc.putc(dev.getc());
        if(!codeIn){
            if(dev.getc() == 'a'){
                dev.printf("Send code 4 digit code.\n"); 
                inNdx = 0;
                codeIn = true;
               // myShiftbrite.write(0,0,255);
            } 
            else {dev.printf("Command not recognized");}
        } else {
        //    pc.printf("BT entered: %c\n", dev.getc());
            input[inNdx] = dev.getc() - '0';
            if(input[inNdx] > -1){  
            dev.printf("Just entered: %d", input[inNdx]);  
            inNdx++;}
            //break;
        }
    }
    
}
//receive value from PC
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}

int main()
{
    lock = 0.3;
    //reset Shiftbrite
    pc.baud(9600);
    dev.baud(9600);
    esp.baud(9600);
    led1=1,led2=0,led3=0,led4=0;
    // Setup a serial interrupt function to receive data
    esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    esp.attach(&Tx_interrupt, Serial::TxIrq);
    if (time(NULL) < 1420070400) {
        setRTC();
    }
    startserver();
    DataRX=0;
    count=0;
    //Set up interrupt
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    //Set up read methods bluetooth and PC
    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
    
    dev.printf("Monitoring Locked Device\n");
    dev.printf("To unlock the device remotely, send 'a'.\n");

    while(1) {
         if(DataRX==1) {
            ReadWebData();
            esp.attach(&Rx_interrupt, Serial::RxIrq);
        }
        if(update==1) // update time, hit count, and analog levels in the HUZZAH chip
        {
            // get new values
            gettime();
            getDS();
            count++;
            // send new values
            pc.printf("\n\n\n\n%f\r\n\n\n\n", DSin );
            if (DSin <= 0.5) {
                strcpy(gotMail, "yes");
                strcpy(audio1, "http://192.168.43.91/img/youGotmail.mp3");
                sprintf(cmdbuff, "count,time,yesorno, audio1=%d,\"%s\",\"%s\",\"%s\"\r\n",count,timebuf,gotMail, audio1);
                SendCMD();
                getreply();
               // continue;
            } else {
                strcpy(gotMail, "no");
                strcpy(audio1, "#");
            }
            sprintf(cmdbuff, "count,time,yesorno,audio1=%d,\"%s\",\"%s\",\"%s\"\r\n",count,timebuf,gotMail, audio1);
            SendCMD();
            getreply();
            update=0;   
        }
        //If four characters have been entered, attempt to unlock
        if (inNdx > 3) {
            dev.printf("Attempting to Unlock\n");
            codeIn = false;
            bool c1 = true; bool c2 = true; bool c3 = true;
            //check entered code against saved codes
            for(int x = 0; x <= 3; x++){
                //if no code matches, end loop
                if(!(c1 | c2 | c3)) {
                    break;    
                } else {
                    //compare codes
                    if (code1[x] != input[x]){c1 = false;}
                    if (code2[x] != input[x]){c2 = false;}
                    if (code3[x] != input[x]){c3 = false;}
                    
                }   
            }
            if(c1){
                //Send welcome user 1 to bluetooth
                dev.printf("Welcome User 1\n");
                lock = 1.0;
                wait(1.0);
                doorPulley.speed(-0.8);
                wait(2.0);
                doorPulley.speed(0.0);
                wait(.3);
                mailFeed.speed(-0.8);
                wait(2);
                mailFeed.speed(0.0);
                doorPulley.speed(0.3);
                wait(1.0);
                doorPulley.speed(0.0);
            } else if(c2) {
                //Send welcome user 2 to bluetooth
                dev.printf("Welcome User 2\n");
                lock = 1.0;
                wait(1.0);
                doorPulley.speed(-0.8);
                wait(2.0);
                doorPulley.speed(0.0);
                wait(.3);
                mailFeed.speed(-0.8);
                wait(2);
                mailFeed.speed(0.0);
                doorPulley.speed(0.3);
                wait(1.0);
                doorPulley.speed(0.0);
                doorPulley.speed(.3);
                wait(.8);
                doorPulley.speed(0.0);
                

            } else if(c3) {
                //Send welcome user 3 to bluetooth
                dev.printf("Welcome User 3\n");
                lock = 1.0;
                wait(1.0);
                doorPulley.speed(-0.8);
                wait(2.0);
                doorPulley.speed(0.0);
                wait(.3);
                mailFeed.speed(-0.8);
                wait(2);
                mailFeed.speed(0.0);
                doorPulley.speed(0.3);
                wait(1.0);
                doorPulley.speed(0.0);

            } else {
                //Send welcome Try Again message to bluetooth
                dev.printf("Try Again\n");
                lock = 0.3;

 
            }
            //reset indexing variable when checking is complete
            inNdx = 0;
            
        }
    }
    
}
// Reads and processes GET and POST web data
void ReadWebData()
{
    wait_ms(200);
    esp.attach(NULL,Serial::RxIrq);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    strcpy(webdata, rx_buffer);
    memset(rx_buffer, '\0', sizeof(rx_buffer));
    rx_in = 0;
    rx_out = 0;
    // check web data for form information
    if( strstr(webdata, "check=led1v") != NULL ) {
        led1=!led1;
        DSin = 0;
    }
    if( strstr(webdata, "check=led2v") != NULL ) {
        led2=!led2;
    }
    if( strstr(webdata, "check=led3v") != NULL ) {
        led3=!led3;
    }
    if( strstr(webdata, "check=led4v") != NULL ) {
        led4=!led4;
    }
    if( strstr(webdata, "POST") != NULL ) { // set update flag if POST request
        update=1;
    }
    if( strstr(webdata, "GET") != NULL && strstr(webdata, "favicon.ico") == NULL ) { // set update flag for GET request but do not want to update for favicon requests
        update=1;
    }
}
// Starts webserver
void startserver()
{
    gettime();
    strcpy(audio1, "#");
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"node.restart()\r\n");
    SendCMD();
    wait(2);
    getreply();
    
    pc.printf("\n++++++++++ Starting Server ++++++++++\r\n> ");

    // initial values
    sprintf(cmdbuff, "count,time,yesorno,audio1=0,\"%s\",\"%s\",\"%s\"\r\n",timebuf,gotMail, audio1);
    SendCMD();
    getreply();
    wait(0.5);

    //create server
    sprintf(cmdbuff, "srv=net.createServer(net.TCP,%d)\r\n",SERVtimeout);
    SendCMD();
    getreply();
    wait(0.5);
    strcpy(cmdbuff,"srv:listen(80,function(conn)\r\n");
    SendCMD();
    getreply();
    wait(0.3);
        strcpy(cmdbuff,"conn:on(\"receive\",function(conn,payload) \r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        //print data to mbed
        strcpy(cmdbuff,"print(payload)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
       
        //web page data
        strcpy(cmdbuff,"conn:send('<!DOCTYPE html><html><style> h1 {background: #00000;} </style>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff, "conn:send('<body><h1>Huzzah Mail Receive Notification Center</h1>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('Hit count: '..count..'')\r\n");
        SendCMD();
        getreply();
        wait(0.2);
        strcpy(cmdbuff,"conn:send('<br>Last hit (based on mbed RTC time): '..time..'<br><hr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<h2>Do you have mail?: '..yesorno..' </h2>')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<audio autoplay src= '..audio1..' ></audio><hr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);



        strcpy(cmdbuff,"conn:send('<form name=\"form1\" method=\"POST\"')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led1v\"> Unlock mailbox?')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led2v\"> flip LED2')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led3v\"> flip LED3')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led4v\"> flip LED4')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff,"conn:send('<p><input type=\"submit\" value=\"Check Mail\"></form>')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<script type=\"text/javascript\"> window.onload=function(){window.setTimeout(\"document.form1.submit();\", 5000);}</script>')\r\n");
        SendCMD();
        wait(0.4);
        strcpy(cmdbuff, "conn:send('<p><h2>How to use:</h2><ul><li>Data will automatically update every 5 seconds</li><li>Click Check Mail to manually send data and refresh values</li></ul></body></html>')\r\n");
        SendCMD();
        getreply();
        wait(0.5); 
        // end web page data
        strcpy(cmdbuff, "conn:on(\"sent\",function(conn) conn:close() end)\r\n"); // close current connection
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "end)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
    strcpy(cmdbuff, "end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);

    strcpy(cmdbuff, "tmr.alarm(0, 1000, 1, function()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "if wifi.sta.getip() == nil then\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "print(\"Connecting to AP...\\n\")\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "else\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "ip, nm, gw=wifi.sta.getip()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"print(\"IP Address: \",ip)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"tmr.stop(0)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    
    pc.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
}


// ESP Command data send
void SendCMD()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Get Command and ESP status replies
void getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}
 
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}
 
 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    DataRX=1;
    //getDS();
    //led3=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = esp.getc();
// Uncomment to Echo to USB serial to watch data flow
        pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    //led3=0;
    return;
}
 
 
// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((esp.writeable()) && (tx_in != tx_out)) {
        esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    //led2=0;
    return;
}

void gettime()
{
    time_t seconds = time(NULL);
    strftime(timebuf,50,"%H:%M:%S %a %d %b %y", localtime(&seconds));
}

void setRTC()
{
    t.tm_sec = (0);             // 0-59
    t.tm_min = (minute);        // 0-59
    t.tm_hour = (hour);         // 0-23
    t.tm_mday = (dayofmonth);   // 1-31
    t.tm_mon = (month-1);       // 0-11  "0" = Jan, -1 added for Mbed RCT clock format
    t.tm_year = ((year)+100);   // year since 1900,  current DCF year + 100 + 1900 = correct year
    set_time(mktime(&t));       // set RTC clock
}

void getDS()
{
    DSin = ds.read();
}