#include "mbed.h"

#define     OLED_FONT5X7                    0x01
#define     OLED_FONT8X8                    0x02
#define     OLED_FONT8X12                   0x03

#define     OLED_DISPLAYCONTROL_DISPLAY     0x01
#define     OLED_DISPLAYCONTROL_CONTRAST    0x02
#define     OLED_DISPLAYCONTROL_POWER       0x03

class MicroOLED {
public:

    MicroOLED(PinName serialTX, PinName serialRX, PinName reset);

    short getRGB(char red, char green, char blue);

    bool addBitmappedCharacter(char character, char data[8]);
    bool blockCopyPaste(char sourceX, char sourceY, char destinationX, char destinationY, char width, char height);
    bool displayControl(char mode);
    bool displayUserBitmappedCharacter(char character, char x, char y, short color);
    bool drawCircle(char x, char y, char radius, short color);
    bool drawCharacter(char character, char column, char row, short color);
    bool drawImage(char x, char y, char width, char height, char colorMode, char *pixels);
    bool drawLine(char x1, char y1, char x2, char y2, short color);
    bool drawPolygon(char vertices, char *x, char *y, short color);
    bool drawRectangle(char x, char y, char width, char height, short color);
    bool drawText(char column, char row, char font, short color, char *text);
    bool drawTriangle(char x1, char y1, char x2, char y2, char x3, char y3, short color);
    bool eraseScreen();
    bool init();
    bool penSize(char size);
    bool putPixel(char x, char y, short color);
    short readPixel(char x, char y);
    bool setBackgroundColor(short color);
    bool setFontSize(char fontType);
    bool textButton(char state, char x, char y, short buttonColor, char font, short textColor, char textWidth, char textHeight, char *text);
    bool textMode(char mode);
    bool versionInfo(bool onScreen, char *info);
    
    
protected:
    Serial      _oled;
    DigitalOut  _reset;
    
    void resetDisplay();
};#include "mbed.h"

#define     OLED_FONT5X7                    0x01
#define     OLED_FONT8X8                    0x02
#define     OLED_FONT8X12                   0x03

#define     OLED_DISPLAYCONTROL_DISPLAY     0x01
#define     OLED_DISPLAYCONTROL_CONTRAST    0x02
#define     OLED_DISPLAYCONTROL_POWER       0x03

class MicroOLED {
public:

    MicroOLED(PinName serialTX, PinName serialRX, PinName reset);

    short getRGB(char red, char green, char blue);

    bool addBitmappedCharacter(char character, char data[8]);
    bool blockCopyPaste(char sourceX, char sourceY, char destinationX, char destinationY, char width, char height);
    bool displayControl(char mode);
    bool displayUserBitmappedCharacter(char character, char x, char y, short color);
    bool drawCircle(char x, char y, char radius, short color);
    bool drawCharacter(char character, char column, char row, short color);
    bool drawImage(char x, char y, char width, char height, char colorMode, char *pixels);
    bool drawLine(char x1, char y1, char x2, char y2, short color);
    bool drawPolygon(char vertices, char *x, char *y, short color);
    bool drawRectangle(char x, char y, char width, char height, short color);
    bool drawText(char column, char row, char font, short color, char *text);
    bool drawTriangle(char x1, char y1, char x2, char y2, char x3, char y3, short color);
    bool eraseScreen();
    bool init();
    bool penSize(char size);
    bool putPixel(char x, char y, short color);
    short readPixel(char x, char y);
    bool setBackgroundColor(short color);
    bool setFontSize(char fontType);
    bool textButton(char state, char x, char y, short buttonColor, char font, short textColor, char textWidth, char textHeight, char *text);
    bool textMode(char mode);
    bool versionInfo(bool onScreen, char *info);
    
    
protected:
    Serial      _oled;
    DigitalOut  _reset;
    
    void resetDisplay();
};