/*
ButtonIn is a debouncing InterruptIn class for mbed (http://mbed.org).

Copyright (C) 2012 Erik van Wijk (http://mbed.org/users/evwijk/)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/    

#include "mbed.h"

#ifndef _ButtonIn_
#define _ButtonIn_

class ButtonInCallbackInstance;

class ButtonIn {

private:
    InterruptIn _button;
    Timeout     _buttonDownTimeout;
    
    volatile bool _buttonCanPress;
    void (*_callback)(void);
    ButtonInCallbackInstance *_callbackInstance;
    void (ButtonInCallbackInstance::*_callbackMethod)(void);

    void click();
    void call();
    void reset();


public:
    // ********************************************************************************
    // * Constructor
    // *
    // * @param buttonPin   The pin which is connected to the button.
    // ********************************************************************************
    ButtonIn(PinName buttonPin);

    // ********************************************************************************
    // * Attaches the method to be called when the button is pressed.
    // *
    // * @param method      A reference to the method to be called.
    // ********************************************************************************
    void attach(void (*method)(void) = 0);

    // ********************************************************************************
    // * Attaches the method to be called when the button is pressed.
    // *
    // * @param instance    A reference to the instance of the class containing the 
    // *                    method to be called.
    // * @param method      A reference to the method to be called.
    // ********************************************************************************
    template<class T>
    void attach(T* instance, void (T::*method)(void));
    

    // ********************************************************************************
    // * The time in milliseconds in which the button can not be pressed again.
    // *
    // * @default          20ms
    // ********************************************************************************
    int timeout;
};

#endif