#ifndef SENDER_H
#define SENDER_H

#include "mbed.h"
#include "rtos.h"
#include <vector>
#include <string>

vector<unsigned char> createFrame(const vector<unsigned char> &message);


class Sender{
    
    enum State {prepare, sendData};

    Serial pc;
    
    DigitalOut MO;
    public:
        void send();
        Sender();
        void sendMessage(const vector<unsigned char> & data);
        Ticker _ticker;
    DigitalOut myled;
        
    private:
        void prepareBit();
        State send_state;
        int _byteSentCount;
        int _bitSentCount;
        vector<unsigned char> data;
        bool _next_bit;
        bool _sending;    
};


#endif