#ifndef RECEIVER_H
#define RECEIVER_H

#include "mbed.h"
#include "rtos.h"

#include <vector>


#include "defines.h"
namespace BitData
{
    enum
    {
        zero,
        one,
        timeout
    };
};

class Receiver
{
public:

    Receiver();
    void resetTimer(){time.reset();}
    char getNext();
    
    
    
private:
    void pushData( char bitData );
    void edgeFunction(char mode);
    void rise();
    void fall();

private:
static const int size = 8 * 90 *3;

    Timer time;
    Semaphore dataReady;
    char data[size];


    int lastTime;
    bool timedOut;
    
    int currentData;
    int endData;
};

class ManchesterReceiver
{
public:
    void getMessages();
    
    bool getByte(unsigned char &val);
    
    bool getMessage( vector<unsigned char> &message, int &crc);
    
private:  
    Receiver r;
    
    bool possiblePreamble;
};


    
    
#endif