#include "Receiver.h"
#include "CRC.h"

InterruptIn DO(p21);

extern Serial pc;

Receiver::Receiver():currentData(0),endData(0),lastTime(0),timedOut(true)
{   
    time.start();
    DO.rise(this,&Receiver::rise);
    DO.fall(this,&Receiver::fall);
}

char Receiver::getNext()
{
    if(dataReady.wait(2)==0)
    {
        timedOut = true;
        return BitData::timeout;
    }
    
    char val = data[currentData];
    currentData++;
    if(currentData==size)
        currentData = 0 ;
    return val;
}


void Receiver::pushData(char bitdata)
{
    data[endData] = bitdata;
    endData++;
    if(endData==size)
        endData = 0;    
    dataReady.release();
}

void Receiver::edgeFunction(char mode)
{
    int curTime = time.read_us();
    int dif = curTime - lastTime;
    // timeout
    if( dif > us_timeout)
    {
        pushData(BitData::timeout);
        if(mode == BitData::zero)
        {
            lastTime = curTime;
            pushData(BitData::zero);   
        }
        return;
    }
    // data
    else if(dif > us_prepare)
    {
        lastTime = curTime;
        pushData(mode);
    }
    // else prepare for data
    return;
}

void Receiver::rise()
{
    if(timedOut)
    {
        timedOut = false;
        lastTime = time.read_us();
        pushData(BitData::zero);
        return;
    }
    edgeFunction(BitData::zero);    
}
void Receiver::fall()
{
    if(timedOut)
    {// ignore it, preparation for start
        return;
    }
    edgeFunction(BitData::one);
}



bool ManchesterReceiver::getByte(unsigned char &val)
{
    val =0 ;
    for(int i = 0; i <8; i++)
    {
        char bitData = r.getNext();
        switch(bitData)
        {
        case BitData::zero:
            break;
        case BitData::one:
            val = val|(1 << 7-i);
            break;
        case BitData::timeout:
            val = 0;
            return false;       
        }
    }
    //pc.printf(" byte:%i\n",val);
    return true;
}

bool ManchesterReceiver::getMessage(vector<unsigned char> &message, int& crc )
{
    unsigned char byte = 0;
    // for crc;
    vector<unsigned char> frame;
    
    // wait till a valid byte start the message
    while(byte!=preamble_byte)
    {
        while(!getByte(byte))
        {    }        
    }
    frame.push_back(byte);
    
    if(!getByte(byte)){// timed out 
        return false;
    }
    if(byte!=STARTBYTE)
        return false;
    frame.push_back(byte);
    
    //flags
    if(!getByte( byte))
        return false;
    frame.push_back(byte);
    
    // payload length
    if(!getByte(byte))
        return false;
    
    frame.push_back(byte);
    
    int length = byte;
    //data
    for(int i = 0; i < length; i++)
    {
        if(!getByte(byte)){
            return false;
        }
        message.push_back(byte);
        frame.push_back(byte);
    }
    
    int calccrc = crc16Remainder(frame);
    
    // crc byte1
    if(!getByte(byte))
        return false;
    
    crc = byte << 8;
    // crc byte2
    if(!getByte(byte))
        return false;
    crc = crc | byte;
    
    if(calccrc!=crc)
    {
        pc.printf("\ncrc error\n");
        return false;
    }
    
    // endbyte
    if(!getByte(byte))
        return false;
    if( byte != ENDBYTE )
        return false;
    
    return true;
}

void ManchesterReceiver::getMessages()
{
    while(true)
    {
        vector<unsigned char> message;
        int crc;
        if(getMessage(message,crc))
        {
            for (int i = 0; i < message.size();i++)
            {
                pc.printf("%c", message[i] );
            }
            pc.printf("\nCrc16 : %i\n\n",crc);
        }
        else
        {
            printf("\n\n **********************************\n Echec de reception du message\n\n\n");
        }
        
    }
}

