
#include "sender.h"
#include "defines.h"
#include "CRC.h"
vector<unsigned char> createFrame(const vector<unsigned char> &message)
{
    vector<unsigned char> trame;
    trame.push_back(preamble_byte);
    trame.push_back(STARTBYTE);
    trame.push_back(0x0);
    trame.push_back((unsigned char)message.size());
    for(int i =0;i<message.size();i++){
        trame.push_back(message[i]);   
    }
    int crc;
    crc = crc16Remainder(trame);
    trame.push_back(crc>>8);
    trame.push_back(crc & 0xFF);
    
    trame.push_back(ENDBYTE);
    return trame;
}


void Sender::send()
{
    switch(send_state)
    {
        case prepare:
            prepareBit();           
            MO = _next_bit;
            myled = MO;
            send_state = sendData;
            break;
        case sendData:
            MO = !_next_bit;
            myled = MO;
            send_state = prepare;
            break;    
    }
    
}
void Sender::prepareBit()
{
    if(_byteSentCount == data.size())
    {
        _ticker.detach();    
        _sending = false;
    }
    _next_bit = data[_byteSentCount] & (1 << 7 - _bitSentCount);
//    pc.printf(_next_bit ? "true\n" : "false\n");
    _bitSentCount++;
    if(_bitSentCount==8)
    {
        _bitSentCount = 0;
        _byteSentCount++;
    }
}
void Sender::sendMessage(const vector<unsigned char> & data)
{
    while(_sending == true)
    {
        Thread::yield();
    }
    _sending = true;
    this->data = data;
    send_state = prepare;
    _byteSentCount = 0;
    _bitSentCount = 0;
    _next_bit =false;
    _ticker.detach();
    _ticker.attach_us(callback(this, &Sender::send), us_period/2);   
}

Sender::Sender(): MO(p22),pc(USBTX, USBRX),myled(LED2),_sending(false)
{
    myled = 1;
}