#include "mbed.h"
#include "rtos.h"
#include <vector>
#include "sender.h"

#include "Receiver.h"
#include "defines.h"

#include "CRC.h"

DigitalOut myled(LED1);


DigitalOut MO(p22);
Serial pc(USBTX, USBRX);

#ifndef TESTPERIOD
const int us_period = 20;
const int us_timeout = us_period * 5/4;
const int us_prepare = us_period *3/4;
#else
int us_period = 100;
#endif


const unsigned char preamble_byte = 85;

const unsigned char STARTBYTE = 126;
const unsigned char ENDBYTE = 126;

Sender manchesterSender;

void sendMessage()
{
    unsigned char c = 0;
    vector<unsigned char> message;
    while ( c != '\n')
    {
        while(!pc.readable())
        {
           Thread::wait(1);
        }
        c = pc.getc();
        pc.printf("%c",c);
        message.push_back(c);
    }
    vector<unsigned char> trame = createFrame(message);
    
    manchesterSender.sendMessage(trame);
    
}


#ifdef TESTPERIOD
const int testCount = 2000;
void sendTestData()
{
    vector<unsigned char> trame;
    
    for(int i =0; i < testCount;i++)
    {
        trame.push_back(106);   
    }
    manchesterSender.sendMessage(trame);    
}

int sendMain()
{
    pc.printf("Start test");
    int period;
    while(true)
    {
        pc.scanf("%i",&period);
        pc.printf("\n\nPeriod = %i\n",period);
        us_period = period;
        sendTestData();   
    }
}
int testMain()
{
    ManchesterReceiver r;
    pc.printf("Start test");
    int period;
    while(true)
    {
        pc.scanf("%i",&period);
        pc.printf("\n\nPeriod = %i\n",period);
        us_period = period;
        unsigned char val;
        bool fail = false;
        while(!r.getByte(val))
        {   }
        if(val!=106)
        {
            fail = true;
            pc.printf("Transmit error");
        }
        for(int i = 1; i <testCount ; i++)
        {
            if(!r.getByte(val)){
                pc.printf("transmitError");
                fail = true;
            }
            if(val!=106){
                pc.printf("WrongData");
                fail = true;
            }
        }
        pc.printf("\n\nEnd Period = %i\n",period);
    }
    
}
#endif

int consoleCommMain() {    
    ManchesterReceiver r;
    
    
    
    Callback<void()> cb(&r, &ManchesterReceiver::getMessages);
    Thread receiving(cb,osPriorityHigh);
    
    pc.printf("\n******************\nStarting to listen\n");
    
    while(1)
    {
        sendMessage();
        Thread::wait(1000);
    }
}
int sendMessageTest()
{   
    vector<unsigned char> trame;
    
    for(int i =0; i < 5;i++)
    {
        trame.push_back(106);   
    }
    
    
    trame = createFrame(trame);
    while(true)
        manchesterSender.sendMessage(trame);
        
    return 0;
}


int main()
{
#ifndef TESTPERIOD
    return consoleCommMain();
#else
    return testMain();
#endif
}
