#include "mbed.h"

DigitalOut myled(LED1);

Ticker flipper;
Serial pc(USBTX, USBRX);

Serial xBee(p13, p14);
DigitalOut reset(p8);

const uint8_t START_DELEMITER = 0x7E;
const uint8_t FRAME_TYPE_AT_REQUEST = 0x17;
const uint8_t FRAME_ID = 0x01;
const uint8_t ZERO = 0x00;
const uint8_t APPLY_CHANGES = 0x02;
const uint8_t FF_CONST = 0xFF;
const char OPEN_LED[2] = {'D','1'};


bool atCommand = false;

const int TRANSMIT_REQUEST_DATA = 12;
uint8_t addresse_64_bit[8];
uint8_t addresse_16_bit[2] = {0xFF,0xFE};

uint8_t pan_id[14]={0x7E, 0x00, 0x0A, 0x08, 0x01, 0x49, 0x44, 0x46, 0x46, 0x39, 0x39, 0x31, 0x31, 0x09};

uint8_t nd_Command[8] =  { 0x7E, 0x00, 0x04, 0x08, 0x01, 0x4E, 0x44, 0x64 };

//send to the XBEE
void sendNDCommand()
{
    for ( int i = 0 ; i < 8; i++ ) 
    {
        xBee.putc(nd_Command[i]);
    }
}
//flag for the LED notification
void sendRemoteAtCommand(){
    atCommand = true;
}
//send LED pauqet to turn on of off
void sendRemoteLedCommandPaquet(){
    
    static bool nextState = true;
   // pc.printf("bool %i",nextState);
    uint8_t length = 0x10;
    uint8_t paquet[25];
    uint8_t checkSum= 0x0;
    uint8_t LSBLength;
    uint8_t MSBLength;
    
    char type[2] = { 'D','1'};

    LSBLength = length&0xff;
    MSBLength = 0;
    
    paquet[0] = START_DELEMITER; //start
    paquet[1] = MSBLength; //length MSB
    paquet[2] = LSBLength; //length LSB
    paquet[3] = FRAME_TYPE_AT_REQUEST; //frame type
    paquet[4] = FRAME_ID; //frame id
    for(int i = 5; i < 13;i++) //64 bit addresse
    {
        paquet[i] = addresse_64_bit[i-5];
    }
    paquet[13] = 0xFF;
    paquet[14] = 0xFE;
    
    paquet[15] = APPLY_CHANGES; //BroadCast Radius
    paquet[16] = type[0];
    paquet[17] = type[1];
    
    if(nextState)
    {
        paquet[18] = 0x05;
    }
    else
    {
        paquet[18] = 0x04;
    }
    nextState = !nextState;
    //check sum
    
    for(int i = 3; i<length+3;i++)
    {
        checkSum += paquet[i];
    }
    
    checkSum = FF_CONST - checkSum;
     
    paquet[length+3] = checkSum;
     
     for(int i =0;i<length + 4;i++)
     {
        xBee.putc(paquet[i]);
     }

}
//receie the ND response
void receiveAtCommandResponse(int length, uint8_t* data)
{
    // 1 Command id
    
    uint8_t id = data[1];
    
    // La command est identifie par les deux prochains bits
    uint16_t command = data[2] << 8;
    command += data[3];
    
    pc.printf("\n Command %x\n",command);
    
    uint8_t status = data[4];
    
    // Data == 5-length
    if(status != 0)
    {
        pc.printf("erreur");
        return;
    }
    switch(command)
    {
        
    case 0x4e44: // Node Discovery AT Command
    {
        uint64_t serialNumber = 0;
        addresse_16_bit[0] = data[5];
        addresse_16_bit[1] = data[6];
        pc.printf("\nSerial number :  ");
        for(int i = 7; i < 15; i++)
        {
            serialNumber += data[i] << (8 * (13-i -1) );
            addresse_64_bit[i-7] = data[i];
            pc.printf("%x ",data[i]);
        }
        pc.printf("\n");
        
        return;
    }
    break;
    }
     
}
//receive the data to print
void receiveTransmitRequest(uint8_t* data,int length){
        
    for(int i = TRANSMIT_REQUEST_DATA; i <length;i++)
    {
       pc.printf("%c", data[i]);
    }
}

void stopLed()
{
    myled = 0;
}

void triggerErrorLed()
{
    myled = 1;
    
    static Timeout t;
    t.detach();
    t.attach(stopLed,1.0);
}
//triage for new paquet
void receiveNewPaquet()
{
      int length;
    uint8_t temp = xBee.getc();
    if(temp == START_DELEMITER)
    {
        // MSB
        length = (((xBee.getc()) << 8));
        // LSB
        length +=(xBee.getc());
        uint8_t frame_type = xBee.getc();
        
        uint8_t data[512];
        data[0] = frame_type;
        
        uint8_t checkSum = 0xFF - frame_type;
        
        for(int i = 1; i < length; i++)
        {
            uint8_t temp = xBee.getc();
            if(temp == 0x7E){
                pc.printf("\n Erreur 7e \n");
                
                triggerErrorLed();
                return;                      
            }
            data[i] = temp;
            checkSum-=temp;
        }
        // Mauvais CheckSum
        if(checkSum != xBee.getc())
        {
            pc.printf("\nMauvais checksum\n");
            triggerErrorLed();
        }
        switch (frame_type){
        case 0x90: 
            //pc.printf("ReceiveTransmit");
               receiveTransmitRequest(data,length);
        // AT command Response frame
        break;
        case 0x88:
        
            //pc.printf("\nat response : length %i, frame time %i\n",length,frame_type);
  
            receiveAtCommandResponse(length, data);
                
            break;
        }       
    }  
}



int main() {
    flipper.attach (&sendRemoteAtCommand,1);
    reset =0;
    wait_ms(500);
    reset=1;
    wait(1);
    xBee.printf("+++");
    
    wait(1);
    //
//    for(int i =0;i <14;i++){
//        xBee.putc(pan_id[i]);   
//    }
    sendNDCommand();
    while(1) {
        
        if(xBee.readable()){
                receiveNewPaquet();
        }
        if (atCommand){
            atCommand = false;
            sendRemoteLedCommandPaquet();
        }
    }
}

