#include "CommUART.h"

    CommUART3::CommUART3()
    {
        // Power 
        LPC_SC->PCONP |=  (1 << 25) ;//0x400F C0C4  -> PCUART3
        // Peripheral clock selection -> CCLK
        
        // DLab enable divide latch
        LPC_UART3->LCR |= (1 << 7);
        
        //Default Baud rate of 9600 in serial segment
        // MSB of baud rate divisor
        LPC_UART3->DLM = 0x2;
        // MLB of baud rate divisor
        LPC_UART3->DLL = 0x71;
        
        // want 8-bit characters
        LPC_UART3->LCR = 3;
        
        // Enable FIFO
        LPC_UART3->FCR = 1;
        
        // PINSEL0 1:0 : mode p9 -> 
        LPC_PINCON->PINSEL0 &= ~3;
        LPC_PINCON->PINSEL0 |= 2;
        LPC_SC->PCLKSEL1 &=  ~ (3 << 18  ) ; // clear the bits 18-19
        LPC_SC->PCLKSEL1 |=  1 << 18 ;//0x400F C1AC -> PCLK_UART3 =01
    
    }
    
    void CommUART3::write(char ch)
    {
        LPC_UART3->TER = 0x80;
        LPC_UART3->THR = ch;
    }
    void CommUART3::write(char* ch, int length, char* unused, int unused2)
    {
        for(int i = 0 ; i < length ; i ++)
        {
            write(ch[i]);
        } 
    }