

#include "Afficheur.h"
#ifdef USESPI
    Afficheur::Afficheur():afficheur(p5,p6,p7),chipSelect(p8)
    {
        afficheur.format(8,0);
        afficheur.frequency(50000);
        chipSelect = 0;
    }
#else
    Afficheur::Afficheur():afficheur(),chipSelect(p8)
    {
        chipSelect = 1;
    }
#endif
    void Afficheur::write(char* characters,int length, int commaFlags ) 
    {
        
        Serial pc(USBTX, USBRX);
        static char buf[20];
        resetDisplay();
        afficheur.write(characters,length,buf,20);
        showDot(commaFlags);    
    }
    void Afficheur::write(char ch)
    {
        char buf[1];
        afficheur.write(&ch,1,buf,1);
    }
    void Afficheur::resetDisplay()
    {
        char buf[1];
        afficheur.write("v",1,buf,1);
    }
    void Afficheur::showDot(int expo)
    {
        char command[2] = {'w',expo};
        char buf[2];
        afficheur.write(command,2,buf, 2);
    }
    void Afficheur::hideDot()
    {
        char command[2] = {'w',0};
        char buf[2];
        afficheur.write(command,2,buf, 2);
    }