#include "Accelerometre.h"

namespace
{
    const double PI = 3.14159265359;
    const int  WRITE_DATA = 0x38;
    const int  READ_DATA = 0x39;
}
Accelerometre::Accelerometre():i2c(p28,p27),pc(USBTX, USBRX),acc(p28, p27, 40000){
    
   acc.setBitDepth(MMA8452::BIT_DEPTH_12);
   acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_2G);
   acc.setDataRate(MMA8452::RATE_100);
   
    }
    
void Accelerometre::readxyzAngle(double *Angle){
    double x=0, y=0, z=0;
    acc.readXYZGravity(&x,&y,&z);
    *Angle = AngleCalculation(z);
    
}
    
double Accelerometre::AngleCalculation(double  ZValue){
    if(ZValue>1){
        ZValue = 1;
    }
    if(ZValue <-1){
        ZValue = -1;    
    }
    double  angle =std::acos(ZValue);
     // std::acos return a value from 0 to pi, adjust it to 0 to PI/2 ( 0 , 90 )
    if(angle > PI/2)
    {
        angle = PI - angle;
    }
    return (angle*180/ PI);
}
    

void Accelerometre::writeByte(int regis,int data){
    pc.printf("Reading single byte\n");  
    i2c.start();
    i2c.write(WRITE_DATA);  // A write to device
    i2c.write(regis); // Register to read from (acceleration in X)
    i2c.write(data);
    i2c.stop();
    pc.printf("end\n");
    }

