#ifndef AFFICHEUR_H
#define AFFICHEUR_H


#include "mbed.h"


// Commenter cette ligner pour utiliser le UART pour communiquer avec l'afficheur 7 segments. Sinon, le SPI est utilisé.
 //#define USESPI

#ifndef USESPI
#include "CommUART.h"
#endif


class Afficheur
{
#ifdef USESPI
    typedef SPI CommInterface;
#else
    typedef CommUART3 CommInterface;
#endif
public:
    Afficheur();
    
    void write(char* characters,int length ,int commaFlags);
    void write(char ch);
    void resetDisplay();
    void showDot(int commaFlags);
    void hideDot();
    
    private:
    CommInterface afficheur;
    DigitalOut chipSelect;
};

#endif