#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#define MINE
uLCD_4DGL lcd(p28, p27, p30);
AnalogIn AnalogX(p15);
AnalogIn AnalogY(p16);
SDFileSystem sd(p5,p6,p7,p8,"sd");
AnalogOut DACout(p18);

bool lose = false;

int main() {
    int AnalogXReading;
    int AnalogYReading;
    lcd.baudrate(3000000);
    int mine_field[4][4];
    wave_player waver(&DACout);
    
    
    int round = 1;
    int mine;
    while(round <=3 && lose == false)
    {
        lcd.text_width(2); //2X size text
        lcd.text_height(2);
        lcd.printf("\n  Round \n    %d ", round);
        //printf("%d\n",round);
        int mine_location[round];
        
        for(int i=0; i<4; i++)
        {
            for(int j=0; j<4; j++)
            {
                mine_field[i][j]=0;
            }
        }
        
        for(int i=0;i<round;i++)
        {
            bool same = false;
            mine = rand() % 14 + 1; 
            do
            {
                for(int i=0; i<round; i++)
                {
                    if(mine == mine_location[i])
                    {
                        same = true;
                        mine = rand() % 14 + 1; 
                    }
                    else
                        same = false;
                }
            }while(same == true);

            mine_location[i]=mine;
            mine_field[mine%4][mine/4]=1;
        }
        
        int startPointX=0;
        int startPointY=0;
        bool win=false;
        int previousX=0;
        int previousY=0;
        wait(3);
        lcd.cls();
        while(1) {
            AnalogXReading = AnalogX.read()*128;
            AnalogYReading = AnalogY.read()*128;
            //lcd.cls();
            lcd.line(0, 31 , 127, 31 , 0xFF0000);
            lcd.line(0, 63 , 127, 63 , 0xFF0000);
            lcd.line(0, 95 , 127, 95, 0xFF0000);
            lcd.line(31,0, 31, 127, 0xFF0000);
            lcd.line(63, 0, 63, 127, 0xFF0000);
            lcd.line(95, 0 , 95, 127, 0xFF0000);
            if(AnalogXReading >118)
            {
                if(startPointX<3)
                    startPointX++;
            }
            if(AnalogXReading <10)
            {
                if(startPointX>0)
                    startPointX--;
            }
            if(AnalogYReading >118)
            {
                if(startPointY>0)
                    startPointY--;
            }
            if(AnalogYReading <10)
            {
                if(startPointY<3)
                    startPointY++;
            }
            
            //update ballLocation Here
            lcd.circle(32*startPointX+15, 32*startPointY+15, 5, 0xFF0000);
            #ifdef MINE
            for(int i=0 ; i<4; i++)
            {
                for(int j=0; j<4;j++)
                {
                    if(mine_field[i][j]==1)
                        lcd.circle(32*i+15, 32*j+15, 5, BLUE);
                }
            }
            #endif
            if(previousX != startPointX || previousY!= startPointY)
            {
                lcd.circle(32*previousX+15, 32*previousY+15, 5, GREEN);
                previousX=startPointX;
                previousY=startPointY;
            }
            
            
            if(startPointX == 3 && startPointY == 3)
                win = true;
            else if(mine_field[startPointX][startPointY]==1)
                lose= true;
            
            if(win)
            {
                //make screen green
                lcd.cls();
                if(round ==3)
                {
                    lcd.media_init();
                    lcd.set_sector_address(0x0000, 0x001D);
                    lcd.display_image(0,0);
                }
                break;
            }
            if(lose)
            {
                //make screen red
                lcd.cls();
                lcd.text_width(2); //2X size text
                lcd.text_height(2);
                break;
            }
            wait(1);
        }
        round++;
    }
    lcd.text_width(2); //2X size text
    lcd.text_height(2);
    if(lose == true)
    {
        lcd.printf("You lose! ");
        FILE *wave_file = fopen("/sd/SDfiles/bad_disk_x.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
    }                                                                                    
    else
    {
        lcd.printf("You won!");
        FILE *wave_file = fopen("/sd/SDfiles/applause_y.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
    }
}
