#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

#define STEPS 4096 // Numero de half steps necessarios para uma volta

DigitalOut myled(LED_RED);
DigitalOut M1(D2,0);
DigitalOut M2(D3,0);
DigitalOut M3(D4,0);
DigitalOut M4(D5,0);
Serial pc(USBTX, USBRX);
Mutex m_lum;
AnalogIn LDR(A0);
uint16_t ADC_VALUE;
double highest;
double highest_deg;
double deg;
int last_step;
bool sentido;
double hs_deg = 360/(STEPS/8);
const char* ECHO_SERVER_ADDRESS = "192.168.100.2";

EthernetInterface eth;
//   Threads

Thread thread1;
Thread thread2;
Thread thread3;
Thread thread4;

void udp_client_thread () {
 
    EthernetInterface net;
     
    while(1){
        printf("Ethernet socket example\n");
        int  flag = 1;
        if(flag==1){
            net.connect();
        
            // Show the network address
            const char *ip = net.get_ip_address();
            printf("IP address is: %s\n", ip ? ip : "No IP");
        
            // Open a socket on the network interface, and create a TCP connection to mbed.org
            TCPSocket socket;
            socket.open(&net);
            socket.connect("192.168.100.2", 55);
           
            //char mensagem=ADC_VALUE+'1';
            
            
            //int temporario = ADC_VALUE;
//            temporario = temporario%10;
//            temporario = temporario+48;
//            char mensagem = temporario;
//            
//            
//            temporario = temporario%100;
//            temporario = temporario+48;
//            char mensagem2 = temporario;

            // Send a simple http request    
            char cVal[16];             
            sprintf(cVal,"%d", ADC_VALUE);
            
            char sbuffer[];                                   
            int scount = socket.send(cVal, sizeof cVal);
        
            printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
        
        
            
            
            //pc.printf("Temp Average is: %s\r", cVal);
            
            // Recieve a simple http response and print out the response line
            char rbuffer[64];
            int rcount = socket.recv(rbuffer, sizeof rbuffer);
            printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
            
            if(rbuffer == "m")
                DigitalOut led(LED_RED);
            // Close the socket to return its memory and bring down the network interface
            socket.close();
        
            // Bring down the ethernet interface
            net.disconnect();
            printf("Done\n");
        }
    }
}

//void hs_cw(){
//    
//   
//        M1.write(1);
//        M2.write(1);
//        wait(.02);
//                
//        M1.write(0);
//        wait(.02);
//        
//        M3.write(1);
//        wait(.02);
//        
//        M2.write(0);
//        wait(.02);
//        
//        M4.write(1);
//        wait(.02);
//        
//        M3.write(0);
//        wait(.02);
//        
//        M1.write(1);
//        wait(.02);
//        
//        M4.write(0);
//        wait(.02);
//        
//        M1.write(0);
//        wait(.02);
//    
//    
//    }
//    
//void hs_ccw(){
//    
//        M1.write(1);
//        M4.write(1);
//        wait(.02);
//                
//        M1.write(0);
//        wait(.02);
//        
//        M3.write(1);
//        wait(.02);
//        
//        M4.write(0);
//        wait(.02);
//        
//        M2.write(1);
//        wait(.02);
//        
//        M3.write(0);
//        wait(.02);
//        
//        M1.write(1);
//        wait(.02);
//        
//        M2.write(0);
//        wait(.02);
//        
//        M1.write(0);
//        wait(.02);
//    
//    }
//
///* Retorna uma média dos valores lidos pelo ADC */
//
//double getMedia()
//{
//    char cont;
//    double g_media = 0;
//    for(cont=0; cont<10; cont++) {
//        g_media += ADC_VALUE;
//        wait(.1);
//    }
//    g_media = g_media/10;
//    return g_media;
//}
//
//void step()
//{
//    float tol = 0.05; // Tolerância 5%
//    double media;
//    deg = highest_deg; // Posição inicial
//    while(1) {
//
//        media = getMedia();
//
//        if(media >= highest) {
//            highest = media;
//            highest_deg = deg;
//        } else if(media <= (highest - (highest * tol))) {
//            double n_target; //Variavel que salva a maior luminosidade durante o scan
//            n_target = media;
//            //Tenta procurar mais luminosidade no sentido indicado
//
//            while(1) {
//                
//                if(deg == 180.0 && sentido == 0) { 
//                sentido = !sentido;
//                break;
//                }
//                else if(deg == 0.0 && sentido == 1) {
//                    sentido = !sentido;
//                    break;                    
//                    }
//                if(sentido==1) {
//                    hs_cw();
//                    deg = deg - hs_deg;
//                } else {
//                    hs_ccw();
//                    deg = deg + hs_deg;
//                }
//                media = getMedia();
//                if(media >= n_target) n_target = media;
//                if(media >= (highest - (highest * tol))) {
//                    n_target = media;
//                    while(1) {
//                        if(sentido==1) {
//                            hs_cw();
//                            deg = deg - hs_deg;
//                        } else {
//                            hs_ccw();
//                            deg = deg + hs_deg;
//                        }
//                        media = getMedia();
//                        if(n_target >= media) {
//                            if(sentido==1) {
//                                hs_ccw();
//                                deg = deg + hs_deg;
//                                highest = n_target;
//                                highest_deg = deg;
//                                break;
//                            } else {
//                                hs_cw();
//                                deg = deg - hs_deg;
//                                highest = n_target;
//                                highest_deg = deg;
//                                break;
//                            }
//
//                        }
//
//                    }
//
//                }
//            }
//        } 
//    }
//}
//
//void first_calibration() {
//
//    deg = 0.0; // Angulação inicial
//    sentido = 0; // Anti-Horário
//    highest = getMedia();
//    double c_media;
//
//    while(1){
//    
//        hs_ccw();
//        deg = deg + hs_deg;
//        c_media = getMedia();
//        if(c_media > highest){
//            highest = c_media;
//            highest_deg = deg;
//        }
//        if(deg == 180.0) {
//            while(1){            
//                hs_cw();
//                deg = deg - hs_deg;
//                if(deg == 0.0) 
//                    break;            
//            }
//            while(1){
//                hs_ccw();
//                deg = deg + hs_deg;
//                if(deg == highest_deg) 
//                    break;        
//            }
//            break;
//        }
//    }
//}
//
///* Realiza a leitura do LDR */
void readLDR()
{

    while (1) {
        m_lum.lock();
        ADC_VALUE=LDR.read_u16();
        m_lum.unlock();
        wait(.1);

    }

}
int main (void){ 
    printf("Teste inicializa \n\n");
    eth.connect();
    //first_calibration();
    thread2.start(readLDR);
    //thread3.start(step);
    thread4.start(udp_client_thread);
while(true) { }
 }