#ifndef KEYPAD4x4_H
#define KEYPAD4x4_H

/*
    +-----------------+
    | +-+ +-+ +-+ +-+ |
    | |1| |2| |3| |A| |
    | +-+ +-+ +-+ +-+ |
    | +-+ +-+ +-+ +-+ |
    | |4| |5| |5| |B| |
    | +-+ +-+ +-+ +-+ |
    | +-+ +-+ +-+ +-+ |
    | |7| |8| |9| |C| |
    | +-+ +-+ +-+ +-+ |
    | +-+ +-+ +-+ +-+ |
    | |*| |0| |#| |D| |
    | +-+ +-+ +-+ +-+ |
    +-----------------+
    | o o o o o o o o |  
      C C C C R R R R
      O O O O O O O O
      L L L L W W W W
      0 1 2 3 0 1 2 3
    
*/      
                            
#ifndef BIT
#define BIT(N) (1 << (N))
#endif

//BusOut keypad4x4_columns(KEYPAD4X4_COLUMN0, KEYPAD4X4_COLUMN1, KEYPAD4X4_COLUMN2, KEYPAD4X4_COLUMN3);
//BusIn keypad4x4_rows(KEYPAD4X4_ROW0, KEYPAD4X4_ROW1, KEYPAD4X4_ROW2, KEYPAD4X4_ROW3);
BusOut keypad4x4_columns(PTE19, PTE18, PTE17, PTE16);
BusIn keypad4x4_rows(PTA14, PTA15, PTA16, PTA17);
InterruptIn keypad4x4_interrupt(PTC16);

#define KEYPAD4X4_TYPE_MIN 0
#define KEYPAD4X4_TELEPHONE 0
#define KEYPAD4X4_TELEPHONE_ALT 1
#define KEYPAD4X4_HEXADECIMAL 2
#define KEYPAD4X4_TYPE_MAX 2
#define KEYPAD4X4_TYPE_DEFAULT KEYPAD4X4_TELEPHONE_ALT

#ifndef KEYPAD4X4_TYPE
#define KEYPAD4X4_TYPE KEYPAD4X4_TYPE_DEFAULT
#endif /* #ifndef KEYPAD4X4_TYPE */

#if (KEYPAD4X4_TYPE < KEYPAD4X4_TYPE_MIN) || (KEYPAD4X4_TYPE > KEYPAD4X4_TYPE_MAX)
#warning "invalid KEYPAD4X4_TYPE specified, default KEYPAD4X4_TYPE used"
#undef KEYPAD4X4_TYPE
#define KEYPAD4X4_TYPE KEYPAD4X4_TYPE_DEFAULT
#endif  /* #if (KEYPAD4X4_TYPE < KEYPAD4X4_TYPE_MIN) || (KEYPAD4X4_TYPE > KEYPAD4X4_TYPE_MAX) */

int keypad4x4_type=KEYPAD4X4_TYPE;

char keypad4x4_ASCII[KEYPAD4X4_TYPE_MAX+1][4][4]={ 
                                        {{'1','2','3','A'},{'4','5','6','B'},{'7','8','9','C'},{'*','0','#','D'}}, 
                                        {{'1','2','3','A'},{'4','5','6','B'},{'7','8','9','C'},{'E','0','F','D'}}, 
                                        {{'0','1','2','3'},{'4','5','6','7'},{'8','9','A','B'},{'C','D','E','F'}} };
/* KEYPAD4X4_ASCII[0][][] is KEYPAD4X4_TELEPHONE (e.g. '*' and '#') */                                     
/* KEYPAD4X4_ASCII[1][][] is KEYPAD4X4_TELEPHONE_ALT (e.g. 'E' and 'F')*/ 
/* KEYPAD4X4_ASCII[2][][] is KEYPAD4X4_HEXADECIMAL (e.g. 0-F in order) */ 

int keypad4x4_set_type(int type)
{
    if((type < KEYPAD4X4_TYPE_MIN) || (type > KEYPAD4X4_TYPE_MAX)) { type=KEYPAD4X4_TYPE_DEFAULT; }
    keypad4x4_type=type;
    return(keypad4x4_type);
}

int keypad4x4_query(char *key_value, int * key_row, int *key_column)
{
    int row, column, temp, type;
    keypad4x4_rows.mode(PullDown);

    if((keypad4x4_type < KEYPAD4X4_TYPE_MIN) || (keypad4x4_type > KEYPAD4X4_TYPE_MAX)) 
    { 
        keypad4x4_type=KEYPAD4X4_TYPE_DEFAULT; 
    }

    keypad4x4_columns=0xF;
    if(keypad4x4_rows == 0)
    {
        *key_row=-1;
        *key_column=-1;
        *key_value='\0';
        return(-1);          
    }   

    for (column=0; column < 4; column++)
    {
       row=4;
//       keypad4x4_columns=(1<<column);
       keypad4x4_columns=BIT(column);
       temp=keypad4x4_rows;
       if (temp != 0)
       {
            for(row=0; row <4; row++)
            {
//                if((temp & (1<<row)) != 0)
                if((temp & BIT(row)) != 0)
                {
                    break;
                }
            } 
        }
        if(row<4)
        {
            *key_row=row;
            *key_column=column;
            *key_value=keypad4x4_ASCII[keypad4x4_type][row][column];
            while(keypad4x4_rows != 0) {}   
//            wait(0.01);          
            return((row<<2)+column);
        }
        else
        {
            *key_row=-1;
            *key_column=-1;
            *key_value='\0';
            //return(-1);          
        }
   }
   return(-3);
}   /* end of KEYPAD4X4_query() */

char keypad4x4_getc(void)
{
    int row, column, type, temp;
    char c;
    while((temp=keypad4x4_query(&c, &row, &column)) < 0)
    { }
    return(c);
 
}   /* end of keypad4x4_getc() */
    
int keypad4x4_input(char *key_value, int * key_row, int *key_column)
{
    int row, column, temp, type;
    char c;

    while((temp=keypad4x4_query(&c, &row, &column)) < 0)
    { }
    *key_row=row;
    *key_column=column;
    *key_value=c;    
    return(temp);


}   /* end of KEYPAD4X4_input() */





#endif /* #ifndef KEYPAD4x4_H */