#ifndef HCSR04_H
#define HCSR04_H

// The following lines MUST be added into the main() routine
/*
HCSR04_timer.start();
HCSR04_echo.rise(&echo_start);
HCSR04_echo.fall(&echo_end);
HCSR04_start.attach(&pulse_trigger, 100E-3);
*/

DigitalOut HCSR04_trigger(PTC13);
InterruptIn HCSR04_echo(PTC16); 
Ticker HCSR04_start;
Timer HCSR04_timer;
float HCSR04_time, HCSR04_inches, HCSR04_cm;

void HCSR04_pulse_trigger()
{
    HCSR04_trigger.write(1);
    wait(10E-6);
    HCSR04_trigger.write(0);
}

void HCSR04_echo_start()
{
    HCSR04_timer.reset();
}

void HCSR04_echo_end()
{
    HCSR04_time=HCSR04_timer.read();
    if(HCSR04_time < 30E-3)   // delay longer than 30 ms indicates no echo
    {
        HCSR04_inches=HCSR04_time*13503.9*0.5;     // speed of sound = 13503.9 inches/second and distance to object is 1/2 path length;
        HCSR04_cm=HCSR04_time*34300.0*0.5;     // speed of sound = 34300 cm/second and distance to object is 1/2 path length;
    }
    else
    {
        HCSR04_inches=-1.0;
        HCSR04_cm=-1.0;
    }
}


#endif //HCSR04_H